/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.handler;

import com.epam.ta.reportportal.auth.basic.DatabaseUserDetailsService;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.reporting.async.handler.ReportingMessageHandler;
import com.epam.ta.reportportal.reporting.async.message.MessageRetriever;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.reporting.FinishTestItemRQ;
import java.util.Map;
import java.util.Optional;
import org.springframework.amqp.core.Message;
import org.springframework.stereotype.Service;

@Service
public class TestItemFinishMessageHandler
implements ReportingMessageHandler {
    private final MessageRetriever retriever;
    private final FinishTestItemHandler finishTestItemHandler;
    private final ProjectExtractor projectExtractor;
    private final DatabaseUserDetailsService userDetailsService;

    public TestItemFinishMessageHandler(MessageRetriever retriever, FinishTestItemHandler finishTestItemHandler, ProjectExtractor projectExtractor, DatabaseUserDetailsService userDetailsService) {
        this.retriever = retriever;
        this.finishTestItemHandler = finishTestItemHandler;
        this.projectExtractor = projectExtractor;
        this.userDetailsService = userDetailsService;
    }

    @Override
    public void handleMessage(Message message) {
        Optional<FinishTestItemRQ> finishTestItemRQ = this.retriever.retrieveValid(message, FinishTestItemRQ.class);
        Map headers = message.getMessageProperties().getHeaders();
        finishTestItemRQ.ifPresent(rq -> {
            String username = (String)headers.get("username");
            String projectName = (String)headers.get("projectName");
            String itemId = (String)headers.get("itemId");
            ReportPortalUser user = (ReportPortalUser)this.userDetailsService.loadUserByUsername(username);
            this.finishTestItemHandler.finishTestItem(user, this.projectExtractor.extractProjectDetails(user, projectName), itemId, (FinishTestItemRQ)rq);
        });
    }
}

