/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.consumer;

import com.epam.ta.reportportal.reporting.async.config.RequestType;
import com.epam.ta.reportportal.reporting.async.handler.ReportingMessageHandler;
import com.epam.ta.reportportal.reporting.async.handler.provider.ReportingHandlerProvider;
import java.util.Optional;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.stereotype.Component;

@Component
public class ReportingConsumer
implements MessageListener {
    private final ReportingHandlerProvider handlerProvider;

    public ReportingConsumer(ReportingHandlerProvider handlerProvider) {
        this.handlerProvider = handlerProvider;
    }

    public void onMessage(Message message) {
        RequestType requestType = this.getRequestType(message);
        Optional<ReportingMessageHandler> messageHandler = this.handlerProvider.provideHandler(requestType);
        messageHandler.ifPresent(handler -> handler.handleMessage(message));
    }

    private RequestType getRequestType(Message message) {
        return RequestType.valueOf((String)message.getMessageProperties().getHeaders().get("requestType"));
    }
}

