/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class UnbindQueuesOnShutdown
implements DisposableBean {
    private final List<Binding> bindings;
    private final List<String> queues;
    private final AmqpAdmin amqpAdmin;

    public UnbindQueuesOnShutdown(@Qualifier(value="reportingBindings") List<Binding> bindings, @Qualifier(value="reportingQueues") List<Queue> queues, AmqpAdmin amqpAdmin) {
        this.bindings = bindings;
        this.queues = queues.stream().map(Queue::getName).collect(Collectors.toList());
        this.amqpAdmin = amqpAdmin;
    }

    public void destroy() {
        this.bindings.forEach(arg_0 -> ((AmqpAdmin)this.amqpAdmin).removeBinding(arg_0));
        this.queues.forEach(q -> this.amqpAdmin.deleteQueue(q, true, true));
    }
}

