/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.plugin;

import com.epam.reportportal.extension.common.IntegrationTypeProperties;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.pf4j.DefaultExtensionFactory;
import org.pf4j.PluginManager;
import org.pf4j.PluginWrapper;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;

public class ReportPortalExtensionFactory
extends DefaultExtensionFactory {
    private final String resourcesDir;
    private final PluginManager pluginManager;
    private final AbstractAutowireCapableBeanFactory beanFactory;

    public ReportPortalExtensionFactory(String resourcesDir, PluginManager pluginManager, AutowireCapableBeanFactory context) {
        this.resourcesDir = resourcesDir;
        this.pluginManager = pluginManager;
        this.beanFactory = (AbstractAutowireCapableBeanFactory)context;
    }

    public <T> T create(Class<T> extensionClass) {
        PluginWrapper pluginWrapper = this.pluginManager.whichPlugin(extensionClass);
        if (this.beanFactory.containsSingleton(pluginWrapper.getPluginId())) {
            return extensionClass.cast(this.beanFactory.getSingleton(pluginWrapper.getPluginId()));
        }
        return extensionClass.cast(this.createExtension(extensionClass, pluginWrapper));
    }

    private <T> T createExtension(Class<T> extensionClass, PluginWrapper pluginWrapper) {
        Map<String, Object> initParams = this.getInitParams(pluginWrapper);
        T plugin = this.createPlugin(extensionClass, initParams);
        this.beanFactory.autowireBean(plugin);
        this.beanFactory.initializeBean(plugin, pluginWrapper.getDescriptor().getPluginId());
        this.beanFactory.registerSingleton(pluginWrapper.getDescriptor().getPluginId(), plugin);
        if (DisposableBean.class.isAssignableFrom(extensionClass)) {
            this.beanFactory.registerDisposableBean(pluginWrapper.getDescriptor().getPluginId(), (DisposableBean)plugin);
        }
        return plugin;
    }

    private <T> T createPlugin(Class<T> extensionClass, Map<String, Object> initParams) {
        try {
            return extensionClass.getDeclaredConstructor(Map.class).newInstance(initParams);
        }
        catch (Exception ex) {
            return (T)super.create(extensionClass);
        }
    }

    private Map<String, Object> getInitParams(PluginWrapper pluginWrapper) {
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        initParams.put(IntegrationTypeProperties.RESOURCES_DIRECTORY.getAttribute(), Paths.get(this.resourcesDir, pluginWrapper.getPluginId()));
        return initParams;
    }
}

