/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.plugin;

import com.epam.reportportal.extension.common.IntegrationTypeProperties;
import com.epam.ta.reportportal.core.plugin.Pf4jPluginBox;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.google.common.collect.Lists;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.pf4j.PluginManager;
import org.pf4j.update.DefaultUpdateRepository;
import org.pf4j.update.PluginInfo;
import org.pf4j.update.SimpleFileDownloader;
import org.pf4j.update.UpdateManager;
import org.pf4j.update.UpdateRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PluginStartUpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginStartUpService.class);
    @Value(value="${rp.plugins.default.load}")
    private boolean defaultPluginsLoad;
    private final PluginManager pluginManager;
    private final Pf4jPluginBox pluginBox;
    private final IntegrationTypeRepository integrationTypeRepository;

    @PostConstruct
    public void loadPlugins() {
        UpdateManager updateManager;
        this.pluginBox.startUp();
        if (this.defaultPluginsLoad && (updateManager = new UpdateManager(this.pluginManager, this.getDefaultPluginRepositories())).hasAvailablePlugins()) {
            updateManager.getAvailablePlugins().forEach(pluginInfo -> this.loadLatestVersion(updateManager, (PluginInfo)pluginInfo));
        }
    }

    private void loadLatestVersion(UpdateManager updateManager, PluginInfo pluginInfo) {
        try {
            PluginInfo.PluginRelease lastRelease = updateManager.getLastPluginRelease(pluginInfo.id);
            if (this.isVersionUploaded(pluginInfo, lastRelease)) {
                return;
            }
            Path path = new SimpleFileDownloader().downloadFile(URI.create(lastRelease.url).toURL());
            this.pluginBox.uploadPlugin(path.getFileName().toString(), Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            log.warn("Can't load default remote plugin with id {}. Error: {}", (Object)pluginInfo.id, (Object)e.getMessage());
        }
    }

    private boolean isVersionUploaded(PluginInfo pluginInfo, PluginInfo.PluginRelease lastRelease) {
        Optional<String> res = this.integrationTypeRepository.findByName(pluginInfo.id).flatMap(it -> Optional.ofNullable(it.getDetails())).flatMap(typeDetails -> IntegrationTypeProperties.VERSION.getValue(typeDetails.getDetails()).map(String::valueOf)).filter(version -> version.equalsIgnoreCase(lastRelease.version));
        if (res.isPresent()) {
            log.info("Plugin with the latest version {} is already loaded", (Object)lastRelease.version);
            return true;
        }
        return false;
    }

    private List<UpdateRepository> getDefaultPluginRepositories() {
        try {
            return Lists.newArrayList((Object[])new UpdateRepository[]{new DefaultUpdateRepository("plugin-import-junit", URI.create("https://raw.githubusercontent.com/reportportal/plugin-import-junit/1.1.0/jars/plugins.json").toURL())});
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return Collections.emptyList();
        }
    }

    @Generated
    public PluginStartUpService(PluginManager pluginManager, Pf4jPluginBox pluginBox, IntegrationTypeRepository integrationTypeRepository) {
        this.pluginManager = pluginManager;
        this.pluginBox = pluginBox;
        this.integrationTypeRepository = integrationTypeRepository;
    }
}

