/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.plugin;

import com.epam.ta.reportportal.plugin.DetailPluginDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginRuntimeException;
import org.pf4j.util.FileUtils;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailManifestPluginDescriptorFinder
implements PluginDescriptorFinder {
    private static final Logger log = LoggerFactory.getLogger(DetailManifestPluginDescriptorFinder.class);
    public static final String PLUGIN_ID = "Plugin-Id";
    public static final String PLUGIN_NAME = "Plugin-Name";
    public static final String PLUGIN_DESCRIPTION = "Plugin-Description";
    public static final String PLUGIN_CLASS = "Plugin-Class";
    public static final String PLUGIN_VERSION = "Plugin-Version";
    public static final String PLUGIN_PROVIDER = "Plugin-Provider";
    public static final String PLUGIN_DEPENDENCIES = "Plugin-Dependencies";
    public static final String PLUGIN_REQUIRES = "Plugin-Requires";
    public static final String PLUGIN_LICENSE = "Plugin-License";
    public static final String PLUGIN_DOCUMENTATION = "Plugin-Documentation";
    public static final String PLUGIN_METADATA_PREFIX = "Plugin-Metadata-";
    public static final String PLUGIN_PROPERTIES_PREFIX = "Plugin-Property-";
    public static final String PLUGIN_BINARY_DATA_PREFIX = "Plugin-Binary-Data-";

    public boolean isApplicable(Path pluginPath) {
        return Files.exists(pluginPath, new LinkOption[0]) && (Files.isDirectory(pluginPath, new LinkOption[0]) || FileUtils.isZipOrJarFile((Path)pluginPath));
    }

    public PluginDescriptor find(Path pluginPath) {
        Manifest manifest = this.readManifest(pluginPath);
        return this.createPluginDescriptor(manifest);
    }

    private PluginDescriptor createPluginDescriptor(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        return DetailPluginDescriptor.builder().pluginId(attributes.getValue(PLUGIN_ID)).pluginName(attributes.getValue(PLUGIN_NAME)).pluginDescription(attributes.getValue(PLUGIN_DESCRIPTION)).pluginClass(attributes.getValue(PLUGIN_CLASS)).version(attributes.getValue(PLUGIN_VERSION)).requires(attributes.getValue(PLUGIN_REQUIRES)).provider(attributes.getValue(PLUGIN_PROVIDER)).license(attributes.getValue(PLUGIN_LICENSE)).documentation(attributes.getValue(PLUGIN_DOCUMENTATION)).dependencies(attributes.getValue(PLUGIN_DEPENDENCIES)).metadata(this.processAttributesByPrefix(attributes, PLUGIN_METADATA_PREFIX)).properties(this.processAttributesByPrefix(attributes, PLUGIN_PROPERTIES_PREFIX)).binaryData(this.processAttributesByPrefix(attributes, PLUGIN_BINARY_DATA_PREFIX)).build();
    }

    private Map<String, Object> processAttributesByPrefix(Attributes attributes, String prefix) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        attributes.entrySet().stream().filter(entry -> entry.getKey().toString().startsWith(prefix)).forEach(entry -> {
            String key = entry.getKey().toString().substring(prefix.length());
            String value = entry.getValue().toString();
            if (StringUtils.isNotNullOrEmpty((String)key)) {
                map.put(key, this.parseValue(value));
            }
        });
        return map;
    }

    private Object parseValue(String value) {
        if (Pattern.matches("^\\d+$", value)) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ignored) {
                return value;
            }
        }
        if (Pattern.matches("^\\d+\\.\\d+$", value)) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException ignored) {
                return value;
            }
        }
        if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            return Boolean.parseBoolean(value);
        }
        return value;
    }

    private Manifest readManifest(Path pluginPath) {
        if (FileUtils.isJarFile((Path)pluginPath)) {
            return this.readManifestFromJar(pluginPath);
        }
        if (FileUtils.isZipFile((Path)pluginPath)) {
            return this.readManifestFromZip(pluginPath);
        }
        return this.readManifestFromDirectory(pluginPath);
    }

    private Manifest readManifestFromJar(Path jarPath) {
        Manifest manifest;
        JarFile jar = new JarFile(jarPath.toFile());
        try {
            manifest = jar.getManifest();
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new PluginRuntimeException((Throwable)e, "Cannot read manifest from {}", new Object[]{jarPath});
            }
        }
        jar.close();
        return manifest;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Manifest readManifestFromZip(Path zipPath) {
        try (ZipFile zip = new ZipFile(zipPath.toFile());){
            Manifest manifest;
            block13: {
                ZipEntry manifestEntry = zip.getEntry("classes/META-INF/MANIFEST.MF");
                InputStream manifestInput = zip.getInputStream(manifestEntry);
                try {
                    manifest = new Manifest(manifestInput);
                    if (manifestInput == null) break block13;
                }
                catch (Throwable throwable) {
                    if (manifestInput != null) {
                        try {
                            manifestInput.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                manifestInput.close();
            }
            return manifest;
        }
        catch (IOException e) {
            throw new PluginRuntimeException((Throwable)e, "Cannot read manifest from {}", new Object[]{zipPath});
        }
    }

    private Manifest readManifestFromDirectory(Path pluginPath) {
        Manifest manifest;
        block10: {
            Path manifestPath = FileUtils.findFile((Path)pluginPath, (String)"MANIFEST.MF");
            if (manifestPath == null) {
                throw new PluginRuntimeException("Cannot find the manifest path");
            }
            log.debug("Lookup plugin descriptor in '{}'", (Object)manifestPath);
            if (Files.notExists(manifestPath, new LinkOption[0])) {
                throw new PluginRuntimeException("Cannot find '{}' path", new Object[]{manifestPath});
            }
            InputStream input = Files.newInputStream(manifestPath, new OpenOption[0]);
            try {
                manifest = new Manifest(input);
                if (input == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PluginRuntimeException((Throwable)e, "Cannot read manifest from {}", new Object[]{pluginPath});
                }
            }
            input.close();
        }
        return manifest;
    }
}

