/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.model.user;

import com.epam.reportportal.annotations.NotBlankString;
import com.epam.ta.reportportal.ws.annotations.In;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EditUserRQ {
    @NotBlankString
    @JsonProperty(value="email")
    private String email;
    @JsonProperty(value="externalId")
    private String externalId;
    @JsonProperty(value="active")
    private Boolean active;
    @In(allowedValues={"user", "administrator"})
    @JsonProperty(value="role")
    private String role;
    @In(allowedValues={"INTERNAL", "SCIM"})
    @JsonProperty(value="accountType")
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED, allowableValues={"INTERNAL, SCIM"})
    private String accountType;
    @NotBlankString
    @Size(min=3, max=256)
    @Pattern(regexp="(\\s*[\\pL0-9-_\\.]+\\s*)+")
    @JsonProperty(value="fullName")
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, example="string")
    private @Size(min=3, max=256) @Pattern(regexp="(\\s*[\\pL0-9-_\\.]+\\s*)+") String fullName;

    @Generated
    public EditUserRQ() {
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getExternalId() {
        return this.externalId;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public String getAccountType() {
        return this.accountType;
    }

    @Generated
    public String getFullName() {
        return this.fullName;
    }

    @JsonProperty(value="email")
    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="externalId")
    @Generated
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @JsonProperty(value="active")
    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @JsonProperty(value="role")
    @Generated
    public void setRole(String role) {
        this.role = role;
    }

    @JsonProperty(value="accountType")
    @Generated
    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    @JsonProperty(value="fullName")
    @Generated
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditUserRQ)) {
            return false;
        }
        EditUserRQ other = (EditUserRQ)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$accountType = this.getAccountType();
        String other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
            return false;
        }
        String this$fullName = this.getFullName();
        String other$fullName = other.getFullName();
        return !(this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EditUserRQ;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
        String $fullName = this.getFullName();
        result = result * 59 + ($fullName == null ? 43 : $fullName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EditUserRQ(email=" + this.getEmail() + ", externalId=" + this.getExternalId() + ", active=" + this.getActive() + ", role=" + this.getRole() + ", accountType=" + this.getAccountType() + ", fullName=" + this.getFullName() + ")";
    }
}

