/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.model.project.email;

import com.epam.reportportal.annotations.NotBlankStringCollection;
import com.epam.ta.reportportal.ws.annotations.In;
import com.epam.ta.reportportal.ws.reporting.ItemAttributeResource;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SenderCaseDTO
implements Serializable {
    private static final long serialVersionUID = -3546546654348861010L;
    @JsonProperty(value="id")
    private Long id;
    @NotEmpty
    @JsonProperty(value="ruleName")
    private String ruleName;
    @JsonProperty(value="recipients")
    private List<String> recipients;
    @NotBlank
    @JsonProperty(value="sendCase")
    @In(allowedValues={"always", "failed", "toInvestigate", "more10", "more20", "more50"})
    @Schema(allowableValues={"always", "failed", "toInvestigate", "more10", "more20", "more50"})
    private String sendCase;
    @NotBlankStringCollection
    @JsonProperty(value="launchNames")
    private List<String> launchNames;
    @Valid
    @JsonProperty(value="attributes")
    private Set<ItemAttributeResource> attributes;
    @JsonProperty(value="enabled")
    private boolean enabled;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="ruleDetails")
    private Map<String, Object> ruleDetails;
    @NotBlank
    @JsonProperty(value="attributesOperator")
    @In(allowedValues={"and", "or"})
    @Schema(allowableValues={"AND, OR"})
    private String attributesOperator;

    public SenderCaseDTO() {
    }

    public SenderCaseDTO(Long id, String ruleName, List<String> recipients, String sendCase, List<String> launchNames, Set<ItemAttributeResource> attributes, boolean enabled, String type, Map<String, Object> ruleDetails, String attributesOperator) {
        this.id = id;
        this.ruleName = ruleName;
        this.recipients = recipients;
        this.sendCase = sendCase;
        this.launchNames = launchNames;
        this.attributes = attributes;
        this.enabled = enabled;
        this.type = type;
        this.ruleDetails = ruleDetails;
        this.attributesOperator = attributesOperator;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public void setRecipients(List<String> recipients) {
        this.recipients = recipients;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public void setSendCase(String value) {
        this.sendCase = value;
    }

    public String getSendCase() {
        return this.sendCase;
    }

    public void setLaunchNames(List<String> value) {
        this.launchNames = value;
    }

    public List<String> getLaunchNames() {
        return this.launchNames;
    }

    public Set<ItemAttributeResource> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set<ItemAttributeResource> attributes) {
        this.attributes = attributes;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getAttributesOperator() {
        return this.attributesOperator;
    }

    public void setAttributesOperator(String attributesOperator) {
        this.attributesOperator = attributesOperator;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, Object> getRuleDetails() {
        return this.ruleDetails;
    }

    public void setRuleDetails(Map<String, Object> ruleDetails) {
        this.ruleDetails = ruleDetails;
    }

    public String toString() {
        return "SenderCaseDTO{id=" + this.id + ", ruleName='" + this.ruleName + "', recipients=" + String.valueOf(this.recipients) + ", sendCase='" + this.sendCase + "', launchNames=" + String.valueOf(this.launchNames) + ", attributes=" + String.valueOf(this.attributes) + ", enabled=" + this.enabled + ", type='" + this.type + "', ruleDetails='" + String.valueOf(this.ruleDetails) + "', attributesOperator='" + this.attributesOperator + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SenderCaseDTO that = (SenderCaseDTO)o;
        return this.enabled == that.enabled && Objects.equals(this.id, that.id) && Objects.equals(this.ruleName, that.ruleName) && Objects.equals(this.recipients, that.recipients) && Objects.equals(this.sendCase, that.sendCase) && Objects.equals(this.launchNames, that.launchNames) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.type, that.type) && Objects.equals(this.ruleDetails, that.ruleDetails) && Objects.equals(this.attributesOperator, that.attributesOperator);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.ruleName, this.recipients, this.sendCase, this.launchNames, this.attributes, this.enabled, this.type, this.ruleDetails, this.attributesOperator);
    }
}

