/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.Iterator;
import lombok.Generated;

public class Page<T>
implements Iterable<T> {
    private final Collection<T> content;
    private final PageMetadata page;

    Page() {
        this(null, null);
    }

    public Page(Collection<T> content, PageMetadata page) {
        this.content = content;
        this.page = page;
    }

    public Page(Collection<T> content, long size, long number, long totalElements, long totalPages) {
        this.content = content;
        this.page = new PageMetadata(size, number, totalElements, totalPages);
    }

    public Page(Collection<T> content, long size, long number, long totalElements) {
        this.content = content;
        this.page = new PageMetadata(size, number, totalElements);
    }

    private static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public Collection<T> getContent() {
        return this.content;
    }

    public PageMetadata getPage() {
        return this.page;
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Page{");
        sb.append("content=").append(this.content);
        sb.append(", page=").append(this.page);
        sb.append('}');
        return sb.toString();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class PageMetadata {
        long number;
        long size;
        Long totalElements;
        Long totalPages;
        Boolean hasNext;

        PageMetadata() {
        }

        public PageMetadata(Integer number, Integer size, Boolean hasNext) {
            this.number = number.intValue();
            this.size = size.intValue();
            this.hasNext = hasNext;
        }

        public PageMetadata(long size, long number, long totalElements, long totalPages) {
            Page.checkArgument(size > -1L, "Size must not be negative!");
            Page.checkArgument(number > -1L, "Number must not be negative!");
            Page.checkArgument(totalElements > -1L, "Total elements must not be negative!");
            Page.checkArgument(totalPages > -1L, "Total pages must not be negative!");
            this.number = number;
            this.size = size;
            this.totalElements = totalElements;
            this.totalPages = totalPages;
        }

        public PageMetadata(long size, long number, long totalElements) {
            this(size, number, totalElements, size == 0L ? 0L : (long)Math.ceil((double)totalElements / (double)size));
        }

        @Generated
        public long getNumber() {
            return this.number;
        }

        @Generated
        public long getSize() {
            return this.size;
        }

        @Generated
        public Long getTotalElements() {
            return this.totalElements;
        }

        @Generated
        public Long getTotalPages() {
            return this.totalPages;
        }

        @Generated
        public Boolean getHasNext() {
            return this.hasNext;
        }
    }
}

