/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ActivityEventResource {
    @NotNull
    @JsonProperty(value="id", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The unique ID of the activity", example="1")
    private Long id;
    @NotNull
    @JsonProperty(value="created_at")
    @Schema(description="The time the activity was created", example="2021-07-01T12:00:00Z")
    private Instant createdAt;
    @NotNull
    @JsonProperty(value="event_name", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The name of the event", example="updateItem")
    private String eventName;
    @JsonProperty(value="object_id")
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The ID of the object on which activity was performed", example="1")
    private Long objectId;
    @NotNull
    @JsonProperty(value="object_name", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The name of the object on which activity was performed", example="Test item name")
    private String objectName;
    @NotNull
    @JsonProperty(value="object_type", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The type of the object on which activity was performed", example="itemIssue")
    private String objectType;
    @JsonProperty(value="project_id")
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The ID of the project", example="1")
    private Long projectId;
    @JsonProperty(value="project_name")
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The name of the project", example="Project name")
    private String projectName;
    @NotNull
    @JsonProperty(value="subject_name", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The name of the subject who performed the activity", example="Username")
    private String subjectName;
    @NotNull
    @JsonProperty(value="subject_type", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The type of the subject who performed the activity", example="user")
    private String subjectType;
    @NotNull
    @JsonProperty(value="subject_id", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The ID of the subject who performed the activity", example="1")
    private String subjectId;
    @JsonProperty(value="details")
    @Schema(description="The details of the activity, for example history of value", example="{\n    \"history\": [\n        {\n            \"field\": \"status\",\n            \"newValue\": \"FAILED\",\n            \"oldValue\": \"PASSED\"\n        }\n    ]\n}\n")
    private Object details;

    @Generated
    ActivityEventResource(Long id, Instant createdAt, String eventName, Long objectId, String objectName, String objectType, Long projectId, String projectName, String subjectName, String subjectType, String subjectId, Object details) {
        this.id = id;
        this.createdAt = createdAt;
        this.eventName = eventName;
        this.objectId = objectId;
        this.objectName = objectName;
        this.objectType = objectType;
        this.projectId = projectId;
        this.projectName = projectName;
        this.subjectName = subjectName;
        this.subjectType = subjectType;
        this.subjectId = subjectId;
        this.details = details;
    }

    @Generated
    public static ActivityEventResourceBuilder builder() {
        return new ActivityEventResourceBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String getEventName() {
        return this.eventName;
    }

    @Generated
    public Long getObjectId() {
        return this.objectId;
    }

    @Generated
    public String getObjectName() {
        return this.objectName;
    }

    @Generated
    public String getObjectType() {
        return this.objectType;
    }

    @Generated
    public Long getProjectId() {
        return this.projectId;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getSubjectName() {
        return this.subjectName;
    }

    @Generated
    public String getSubjectType() {
        return this.subjectType;
    }

    @Generated
    public String getSubjectId() {
        return this.subjectId;
    }

    @Generated
    public Object getDetails() {
        return this.details;
    }

    @JsonProperty(value="id", required=true)
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty(value="created_at")
    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="event_name", required=true)
    @Generated
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @JsonProperty(value="object_id")
    @Generated
    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    @JsonProperty(value="object_name", required=true)
    @Generated
    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    @JsonProperty(value="object_type", required=true)
    @Generated
    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    @JsonProperty(value="project_id")
    @Generated
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @JsonProperty(value="project_name")
    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @JsonProperty(value="subject_name", required=true)
    @Generated
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    @JsonProperty(value="subject_type", required=true)
    @Generated
    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    @JsonProperty(value="subject_id", required=true)
    @Generated
    public void setSubjectId(String subjectId) {
        this.subjectId = subjectId;
    }

    @JsonProperty(value="details")
    @Generated
    public void setDetails(Object details) {
        this.details = details;
    }

    @Generated
    public String toString() {
        return "ActivityEventResource(id=" + this.getId() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", eventName=" + this.getEventName() + ", objectId=" + this.getObjectId() + ", objectName=" + this.getObjectName() + ", objectType=" + this.getObjectType() + ", projectId=" + this.getProjectId() + ", projectName=" + this.getProjectName() + ", subjectName=" + this.getSubjectName() + ", subjectType=" + this.getSubjectType() + ", subjectId=" + this.getSubjectId() + ", details=" + String.valueOf(this.getDetails()) + ")";
    }

    @Generated
    public static class ActivityEventResourceBuilder {
        @Generated
        private Long id;
        @Generated
        private Instant createdAt;
        @Generated
        private String eventName;
        @Generated
        private Long objectId;
        @Generated
        private String objectName;
        @Generated
        private String objectType;
        @Generated
        private Long projectId;
        @Generated
        private String projectName;
        @Generated
        private String subjectName;
        @Generated
        private String subjectType;
        @Generated
        private String subjectId;
        @Generated
        private Object details;

        @Generated
        ActivityEventResourceBuilder() {
        }

        @JsonProperty(value="id", required=true)
        @Generated
        public ActivityEventResourceBuilder id(Long id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="created_at")
        @Generated
        public ActivityEventResourceBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty(value="event_name", required=true)
        @Generated
        public ActivityEventResourceBuilder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        @JsonProperty(value="object_id")
        @Generated
        public ActivityEventResourceBuilder objectId(Long objectId) {
            this.objectId = objectId;
            return this;
        }

        @JsonProperty(value="object_name", required=true)
        @Generated
        public ActivityEventResourceBuilder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        @JsonProperty(value="object_type", required=true)
        @Generated
        public ActivityEventResourceBuilder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @JsonProperty(value="project_id")
        @Generated
        public ActivityEventResourceBuilder projectId(Long projectId) {
            this.projectId = projectId;
            return this;
        }

        @JsonProperty(value="project_name")
        @Generated
        public ActivityEventResourceBuilder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        @JsonProperty(value="subject_name", required=true)
        @Generated
        public ActivityEventResourceBuilder subjectName(String subjectName) {
            this.subjectName = subjectName;
            return this;
        }

        @JsonProperty(value="subject_type", required=true)
        @Generated
        public ActivityEventResourceBuilder subjectType(String subjectType) {
            this.subjectType = subjectType;
            return this;
        }

        @JsonProperty(value="subject_id", required=true)
        @Generated
        public ActivityEventResourceBuilder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        @JsonProperty(value="details")
        @Generated
        public ActivityEventResourceBuilder details(Object details) {
            this.details = details;
            return this;
        }

        @Generated
        public ActivityEventResource build() {
            return new ActivityEventResource(this.id, this.createdAt, this.eventName, this.objectId, this.objectName, this.objectType, this.projectId, this.projectName, this.subjectName, this.subjectType, this.subjectId, this.details);
        }

        @Generated
        public String toString() {
            return "ActivityEventResource.ActivityEventResourceBuilder(id=" + this.id + ", createdAt=" + String.valueOf(this.createdAt) + ", eventName=" + this.eventName + ", objectId=" + this.objectId + ", objectName=" + this.objectName + ", objectType=" + this.objectType + ", projectId=" + this.projectId + ", projectName=" + this.projectName + ", subjectName=" + this.subjectName + ", subjectType=" + this.subjectType + ", subjectId=" + this.subjectId + ", details=" + String.valueOf(this.details) + ")";
        }
    }
}

