/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageUtil {
    private static final int DEFAULT_PAGE_SIZE = 50;

    private PageUtil() {
    }

    public static <T> void iterateOverPages(Sort sort, Function<Pageable, Page<T>> getFunc, Consumer<List<T>> consumer) {
        PageUtil.iterateOverPages(50, sort, getFunc, consumer);
    }

    public static <T> void iterateOverPages(int pageSize, Sort sort, Function<Pageable, Page<T>> getFunc, Consumer<List<T>> consumer) {
        Page<T> pageData = getFunc.apply((Pageable)PageRequest.of((int)0, (int)pageSize, (Sort)sort));
        List content = pageData.getContent();
        consumer.accept(content);
        while (!pageData.isLast()) {
            pageData = getFunc.apply(pageData.nextPageable());
            consumer.accept(pageData.getContent());
        }
    }

    public static <T> void iterateOverContent(int pageSize, Function<Pageable, List<T>> getFunc, Consumer<List<T>> consumer) {
        PageRequest pageRequest = PageRequest.of((int)0, (int)pageSize);
        List<T> content = getFunc.apply((Pageable)pageRequest);
        consumer.accept(content);
        while (content.size() >= pageSize) {
            pageRequest = pageRequest.next();
            content = getFunc.apply((Pageable)pageRequest);
            consumer.accept(content);
        }
    }
}

