/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.core.events.activity.LaunchFinishedEvent;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.job.PageUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.stream.Stream;
import org.apache.commons.lang3.math.NumberUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InterruptBrokenLaunchesJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterruptBrokenLaunchesJob.class);
    private final ApplicationEventPublisher eventPublisher;
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final LogRepository logRepository;
    private final ProjectRepository projectRepository;

    @Autowired
    public InterruptBrokenLaunchesJob(ApplicationEventPublisher eventPublisher, LaunchRepository launchRepository, TestItemRepository testItemRepository, LogRepository logRepository, ProjectRepository projectRepository) {
        this.eventPublisher = eventPublisher;
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.logRepository = logRepository;
        this.projectRepository = projectRepository;
    }

    @Transactional
    public void execute(JobExecutionContext context) {
        LOGGER.info("Interrupt broken launches job has been started");
        PageUtil.iterateOverPages(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"id")}), arg_0 -> ((ProjectRepository)this.projectRepository).findAllIdsAndProjectAttributes(arg_0), projects -> projects.forEach(project -> ProjectUtils.extractAttributeValue((Project)project, (ProjectAttributeEnum)ProjectAttributeEnum.INTERRUPT_JOB_TIME).ifPresent(it -> {
            Duration maxDuration = Duration.ofSeconds(NumberUtils.toLong((String)it, (long)0L));
            try (Stream ids = this.launchRepository.streamIdsWithStatusAndStartTimeBefore(project.getId(), StatusEnum.IN_PROGRESS, Instant.now().minus(maxDuration.toSeconds(), ChronoUnit.SECONDS));){
                ids.forEach(launchId -> {
                    if (!this.testItemRepository.hasItemsInStatusByLaunch(launchId, new StatusEnum[]{StatusEnum.IN_PROGRESS}).booleanValue()) {
                        this.interruptLaunch((Long)launchId);
                    } else if (!this.testItemRepository.hasItemsInStatusAddedLately(launchId, maxDuration, new StatusEnum[]{StatusEnum.IN_PROGRESS}).booleanValue()) {
                        if (this.testItemRepository.hasLogs(launchId, maxDuration, new StatusEnum[]{StatusEnum.IN_PROGRESS}).booleanValue()) {
                            if (!this.logRepository.hasLogsAddedLately(maxDuration, launchId, new StatusEnum[]{StatusEnum.IN_PROGRESS})) {
                                this.interruptItems((Long)launchId);
                            }
                        } else {
                            this.interruptItems((Long)launchId);
                        }
                    }
                });
            }
            catch (Exception ex) {
                LOGGER.error("Interrupting broken launches has been failed", (Throwable)ex);
            }
        })));
    }

    private void interruptLaunch(Long launchId) {
        this.launchRepository.findById((Object)launchId).ifPresent(launch -> {
            launch.setStatus(StatusEnum.INTERRUPTED);
            launch.setEndTime(Instant.now());
            this.launchRepository.save(launch);
            this.publishFinishEvent((Launch)launch);
        });
    }

    private void publishFinishEvent(Launch launch) {
        LaunchFinishedEvent launchFinishedEvent = new LaunchFinishedEvent(launch);
        this.eventPublisher.publishEvent((Object)launchFinishedEvent);
    }

    private void interruptItems(Long launchId) {
        this.testItemRepository.interruptInProgressItems(launchId);
        this.interruptLaunch(launchId);
    }
}

