/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.exception.rest;

import com.epam.reportportal.rules.exception.ErrorType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.http.HttpStatus;

public class StatusCodeMapping {
    private static final Map<ErrorType, HttpStatus> MAPPING = new HashMap<ErrorType, HttpStatus>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(ErrorType.NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.PROJECT_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.LAUNCH_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.TEST_ITEM_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.LOG_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.ROLE_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.USER_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.WIDGET_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.WIDGET_NOT_FOUND_IN_DASHBOARD, HttpStatus.NOT_FOUND);
            this.put(ErrorType.DASHBOARD_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.USER_FILTER_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.TEST_SUITE_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.ACTIVITY_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.ISSUE_TYPE_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.PROJECT_SETTINGS_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.TEST_ITEM_OR_LAUNCH_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.AUTH_INTEGRATION_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.USER_FILTER_NOT_FOUND_IN_PROJECT, HttpStatus.NOT_FOUND);
            this.put(ErrorType.WIDGET_NOT_FOUND_IN_PROJECT, HttpStatus.NOT_FOUND);
            this.put(ErrorType.DASHBOARD_NOT_FOUND_IN_PROJECT, HttpStatus.NOT_FOUND);
            this.put(ErrorType.PATTERN_TEMPLATE_NOT_FOUND_IN_PROJECT, HttpStatus.NOT_FOUND);
            this.put(ErrorType.ANALYZER_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.ATTACHMENT_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.UNABLE_TO_LOAD_BINARY_DATA, HttpStatus.NOT_FOUND);
            this.put(ErrorType.CLUSTER_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.RESOURCE_ALREADY_EXISTS, HttpStatus.CONFLICT);
            this.put(ErrorType.PROJECT_ALREADY_EXISTS, HttpStatus.CONFLICT);
            this.put(ErrorType.USER_ALREADY_EXISTS, HttpStatus.CONFLICT);
            this.put(ErrorType.USER_FILTER_ALREADY_EXISTS, HttpStatus.CONFLICT);
            this.put(ErrorType.ROLE_ALREADY_EXISTS_ERROR, HttpStatus.CONFLICT);
            this.put(ErrorType.FINISH_TIME_EARLIER_THAN_START_TIME, HttpStatus.NOT_ACCEPTABLE);
            this.put(ErrorType.CHILD_START_TIME_EARLIER_THAN_PARENT, HttpStatus.NOT_ACCEPTABLE);
            this.put(ErrorType.INCORRECT_FINISH_STATUS, HttpStatus.NOT_ACCEPTABLE);
            this.put(ErrorType.LAUNCH_IS_NOT_FINISHED, HttpStatus.NOT_ACCEPTABLE);
            this.put(ErrorType.TEST_ITEM_IS_NOT_FINISHED, HttpStatus.NOT_ACCEPTABLE);
            this.put(ErrorType.FINISH_LAUNCH_NOT_ALLOWED, HttpStatus.NOT_ACCEPTABLE);
            this.put(ErrorType.START_ITEM_NOT_ALLOWED, HttpStatus.NOT_ACCEPTABLE);
            this.put(ErrorType.FINISH_ITEM_NOT_ALLOWED, HttpStatus.NOT_ACCEPTABLE);
            this.put(ErrorType.LOGGING_IS_NOT_ALLOWED, HttpStatus.NOT_ACCEPTABLE);
            this.put(ErrorType.REPORTING_ITEM_ALREADY_FINISHED, HttpStatus.NOT_ACCEPTABLE);
            this.put(ErrorType.UNSUPPORTED_MERGE_STRATEGY_TYPE, HttpStatus.NOT_ACCEPTABLE);
            this.put(ErrorType.UNABLE_TO_CREATE_WIDGET, HttpStatus.NOT_ACCEPTABLE);
            this.put(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, HttpStatus.CONFLICT);
            this.put(ErrorType.DEMO_DATA_GENERATION_ERROR, HttpStatus.NOT_ACCEPTABLE);
            this.put(ErrorType.DASHBOARD_UPDATE_ERROR, HttpStatus.CONFLICT);
            this.put(ErrorType.BAD_SAVE_USER_FILTER_REQUEST, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.BAD_SAVE_LOG_REQUEST, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.UNSUPPORTED_TEST_ITEM_TYPE, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.BAD_SAVE_WIDGET_REQUEST, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.BAD_UPDATE_WIDGET_REQUEST, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.FAILED_TEST_ITEM_ISSUE_TYPE_DEFINITION, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.BAD_UPDATE_PREFERENCE_REQUEST, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.IMPORT_FILE_ERROR, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.PARSING_XML_ERROR, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, HttpStatus.CONFLICT);
            this.put(ErrorType.PATTERN_ANALYSIS_ERROR, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.INCORRECT_FILTER_PARAMETERS, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.INCORRECT_SORTING_PARAMETERS, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.PLUGIN_UPLOAD_ERROR, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.PLUGIN_REMOVE_ERROR, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.OBJECT_RETRIEVAL_ERROR, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.UNABLE_TO_SAVE_CHILD_ITEM_FOR_THE_RETRY, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.INTEGRATION_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.INTEGRATION_ALREADY_EXISTS, HttpStatus.CONFLICT);
            this.put(ErrorType.PROJECT_NOT_CONFIGURED, HttpStatus.NOT_FOUND);
            this.put(ErrorType.INCORRECT_AUTHENTICATION_TYPE, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.INCORRECT_INTEGRATION_NAME, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, HttpStatus.CONFLICT);
            this.put(ErrorType.SERVER_SETTINGS_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.SERVER_SETTINGS_ALREADY_EXISTS, HttpStatus.CONFLICT);
            this.put(ErrorType.EMAIL_CONFIGURATION_IS_INCORRECT, HttpStatus.FORBIDDEN);
            this.put(ErrorType.ACCESS_DENIED, HttpStatus.FORBIDDEN);
            this.put(ErrorType.ADDRESS_LOCKED, HttpStatus.FORBIDDEN);
            this.put(ErrorType.INCORRECT_REQUEST, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.BAD_REQUEST_ERROR, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.AMBIGUOUS_TEST_ITEM_STATUS, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.UNCLASSIFIED_ERROR, HttpStatus.INTERNAL_SERVER_ERROR);
            this.put(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, HttpStatus.INTERNAL_SERVER_ERROR);
            this.put(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.UNABLE_POST_TICKET, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.FORBIDDEN_OPERATION, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.UNABLE_ADD_TO_FAVORITE, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.UNABLE_MODIFY_SHARABLE_RESOURCE, HttpStatus.UNPROCESSABLE_ENTITY);
            this.put(ErrorType.UNABLE_REMOVE_FROM_FAVORITE, HttpStatus.BAD_REQUEST);
            this.put(ErrorType.PROJECT_DOESNT_CONTAIN_USER, HttpStatus.UNPROCESSABLE_ENTITY);
            this.put(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, HttpStatus.UNPROCESSABLE_ENTITY);
            this.put(ErrorType.UNABLE_TO_UPDATE_YOURSELF_ROLE, HttpStatus.UNPROCESSABLE_ENTITY);
            this.put(ErrorType.PROJECT_UPDATE_NOT_ALLOWED, HttpStatus.UNPROCESSABLE_ENTITY);
            this.put(ErrorType.TICKET_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.ORGANIZATION_NOT_FOUND, HttpStatus.NOT_FOUND);
            this.put(ErrorType.RETRIES_HANDLER_ERROR, HttpStatus.BAD_REQUEST);
        }
    };

    private StatusCodeMapping() {
    }

    public static HttpStatus getHttpStatus(ErrorType errorType, HttpStatus defaultStatus) {
        return StatusCodeMapping.getHttpStatus(errorType).orElse(defaultStatus);
    }

    public static Optional<HttpStatus> getHttpStatus(ErrorType errorType) {
        return Optional.ofNullable(MAPPING.get(errorType));
    }
}

