/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.exception.rest;

import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.exception.rest.ErrorResolver;
import com.epam.ta.reportportal.exception.rest.RestError;
import com.epam.ta.reportportal.exception.rest.StatusCodeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class ReportPortalExceptionResolver
implements ErrorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportPortalExceptionResolver.class);

    @Override
    public RestError resolveError(Exception ex) {
        LOGGER.error("ReportPortalExceptionResolver > {}", (Object)ex.getMessage(), (Object)ex);
        ReportPortalException currentException = (ReportPortalException)((Object)ex);
        RestError.Builder builder = new RestError.Builder();
        builder.setMessage(currentException.getMessage()).setStatus(StatusCodeMapping.getHttpStatus(currentException.getErrorType(), HttpStatus.INTERNAL_SERVER_ERROR)).setError(currentException.getErrorType());
        return builder.build();
    }
}

