/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demodata.service;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.demodata.model.DemoLaunch;
import com.epam.ta.reportportal.demodata.model.RootMetaData;
import com.epam.ta.reportportal.demodata.model.Suite;
import com.epam.ta.reportportal.demodata.service.DemoDataFacade;
import com.epam.ta.reportportal.demodata.service.DemoDataLaunchService;
import com.epam.ta.reportportal.demodata.service.DemoLogsService;
import com.epam.ta.reportportal.demodata.service.generator.SuiteGenerator;
import com.epam.ta.reportportal.demodata.service.generator.SuiteGeneratorResolver;
import com.epam.ta.reportportal.demodata.service.generator.model.SuiteGeneratorType;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.entity.user.User;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.ResourceUtils;

@Service
public class DefaultDemoDataFacade
implements DemoDataFacade {
    public static final int LAUNCH_LOGS_COUNT = 10;
    private final ObjectMapper objectMapper;
    private final DemoDataLaunchService demoDataLaunchService;
    private final DemoLogsService demoLogsService;
    private final SuiteGeneratorResolver suiteGeneratorResolver;
    private final TaskExecutor executor;
    private final UserRepository userRepository;
    @Value(value="classpath:demo/launch/")
    private String resourceFolder;
    @Value(value="${rp.environment.variable.demo.source}")
    private String[] sources;

    public DefaultDemoDataFacade(DemoDataLaunchService demoDataLaunchService, DemoLogsService demoLogsService, ObjectMapper objectMapper, SuiteGeneratorResolver suiteGeneratorResolver, UserRepository userRepository, @Qualifier(value="demoDataTaskExecutor") TaskExecutor executor) {
        this.demoDataLaunchService = demoDataLaunchService;
        this.suiteGeneratorResolver = suiteGeneratorResolver;
        this.demoLogsService = demoLogsService;
        this.objectMapper = objectMapper;
        this.userRepository = userRepository;
        this.executor = executor;
    }

    @Override
    public List<Long> generateDemoLaunches(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        return CompletableFuture.supplyAsync(() -> Stream.of(this.sources).map(source -> this.resourceFolder + source).map(source -> {
            try {
                DemoLaunch demoLaunch = (DemoLaunch)this.objectMapper.readValue(ResourceUtils.getURL((String)source), (TypeReference)new TypeReference<DemoLaunch>(this){});
                return this.generateLaunch(demoLaunch, user, projectDetails);
            }
            catch (IOException e) {
                throw new ReportPortalException("Unable to load suites description. " + e.getMessage(), (Throwable)e);
            }
        }).collect(Collectors.toList()), (Executor)this.executor).join();
    }

    private Long generateLaunch(DemoLaunch demoLaunch, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        User creator = (User)this.userRepository.findById((Object)user.getUserId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{user.getUsername()}));
        Launch launch = this.demoDataLaunchService.startLaunch("Demo Api Tests", creator, projectDetails);
        demoLaunch.getSuites().forEach(suite -> {
            SuiteGeneratorType suiteGeneratorType = SuiteGeneratorType.valueOf(suite.getType());
            SuiteGenerator suiteGenerator = this.suiteGeneratorResolver.resolve(suiteGeneratorType);
            suiteGenerator.generateSuites((Suite)suite, RootMetaData.of(launch.getUuid(), user, projectDetails));
        });
        List<Log> logs = this.demoLogsService.generateLaunchLogs(10, launch.getUuid(), launch.getStatus());
        this.demoDataLaunchService.finishLaunch(launch.getUuid());
        this.demoLogsService.attachFiles(logs, projectDetails.getProjectId(), launch.getUuid());
        return launch.getId();
    }
}

