/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.remover;

import com.epam.ta.reportportal.core.widget.content.materialized.state.WidgetStateResolver;
import com.epam.ta.reportportal.core.widget.content.remover.WidgetContentRemover;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetState;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DelegatingStateContentRemover
implements WidgetContentRemover {
    private final WidgetStateResolver widgetStateResolver;
    private final Map<WidgetState, WidgetContentRemover> widgetContentRemoverMapping;

    @Autowired
    public DelegatingStateContentRemover(WidgetStateResolver widgetStateResolver, Map<WidgetState, WidgetContentRemover> widgetContentRemoverMapping) {
        this.widgetStateResolver = widgetStateResolver;
        this.widgetContentRemoverMapping = widgetContentRemoverMapping;
    }

    @Override
    public void removeContent(Widget widget) {
        if (this.supports(widget)) {
            WidgetState state = this.widgetStateResolver.resolve(widget.getWidgetOptions());
            Optional.ofNullable(this.widgetContentRemoverMapping.get(state)).ifPresent(remover -> remover.removeContent(widget));
        }
    }

    private boolean supports(Widget widget) {
        return Lists.newArrayList((Object[])new String[]{WidgetType.COMPONENT_HEALTH_CHECK_TABLE.getType(), WidgetType.CUMULATIVE.getType()}).contains(widget.getWidgetType());
    }
}

