/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.widget.content.MaterializedLoadContentStrategy;
import com.epam.ta.reportportal.core.widget.content.loader.materialized.handler.MaterializedWidgetStateHandler;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetState;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;

@Service
public class MaterializedLoadContentStrategyImpl
implements MaterializedLoadContentStrategy {
    private final Map<WidgetState, MaterializedWidgetStateHandler> widgetStateHandlerMapping;

    @Autowired
    public MaterializedLoadContentStrategyImpl(@Qualifier(value="widgetStateHandlerMapping") Map<WidgetState, MaterializedWidgetStateHandler> widgetStateHandlerMapping) {
        this.widgetStateHandlerMapping = widgetStateHandlerMapping;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Map<String, Object> loadContent(Widget widget, MultiValueMap<String, String> params) {
        WidgetState widgetState = (WidgetState)Optional.ofNullable(WidgetOptionUtil.getValueByKey("state", widget.getWidgetOptions())).flatMap(WidgetState::findByName).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Widget state not provided"}));
        return this.widgetStateHandlerMapping.get(widgetState).handleWidgetState(widget, params);
    }
}

