/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.user.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.binary.UserBinaryDataService;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.activity.UnassignUserEvent;
import com.epam.ta.reportportal.core.events.activity.UserDeletedEvent;
import com.epam.ta.reportportal.core.events.activity.UsersDeletedEvent;
import com.epam.ta.reportportal.core.project.DeleteProjectHandler;
import com.epam.ta.reportportal.core.project.settings.notification.ProjectRecipientHandler;
import com.epam.ta.reportportal.core.remover.ContentRemover;
import com.epam.ta.reportportal.core.user.DeleteUserHandler;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.enums.ProjectType;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.model.DeleteBulkRS;
import com.epam.ta.reportportal.model.activity.UserActivityResource;
import com.epam.ta.reportportal.util.email.strategy.EmailNotificationStrategy;
import com.epam.ta.reportportal.util.email.strategy.EmailTemplate;
import com.epam.ta.reportportal.ws.converter.converters.ExceptionConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DeleteUserHandlerImpl
implements DeleteUserHandler {
    private final UserBinaryDataService dataStore;
    private final UserRepository userRepository;
    private final DeleteProjectHandler deleteProjectHandler;
    private final ContentRemover<User> userContentRemover;
    private final ProjectRecipientHandler projectRecipientHandler;
    private final ProjectRepository projectRepository;
    private final Map<EmailTemplate, EmailNotificationStrategy> emailNotificationStrategyMapping;
    private final ApplicationEventPublisher applicationEventPublisher;
    private static final String DELETED_USER = "deleted_user";
    @Value(value="${rp.environment.variable.allow-delete-account:false}")
    private boolean isAllowToDeleteAccount;

    @Autowired
    public DeleteUserHandlerImpl(UserRepository userRepository, DeleteProjectHandler deleteProjectHandler, ContentRemover<User> userContentRemover, UserBinaryDataService dataStore, ProjectRecipientHandler projectRecipientHandler, ProjectRepository projectRepository, Map<EmailTemplate, EmailNotificationStrategy> emailNotificationStrategyMapping, ApplicationEventPublisher applicationEventPublisher) {
        this.userRepository = userRepository;
        this.deleteProjectHandler = deleteProjectHandler;
        this.dataStore = dataStore;
        this.userContentRemover = userContentRemover;
        this.projectRecipientHandler = projectRecipientHandler;
        this.projectRepository = projectRepository;
        this.emailNotificationStrategyMapping = emailNotificationStrategyMapping;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    @Transactional
    public OperationCompletionRS deleteUser(Long userId, ReportPortalUser loggedInUser) {
        User deletedUser = this.deleteUserWithAssociatedData(userId, loggedInUser);
        this.publishUserDeletedEvent(deletedUser, loggedInUser);
        return new OperationCompletionRS("User with ID = '" + userId + "' successfully deleted.");
    }

    private User deleteUserWithAssociatedData(Long userId, ReportPortalUser loggedInUser) {
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{userId}));
        this.validateUserDeletion(userId, loggedInUser);
        this.userContentRemover.remove(user);
        List userProjects = this.projectRepository.findAllByUserLogin(user.getLogin());
        userProjects.forEach(project -> {
            if (ProjectUtils.isPersonalForUser((ProjectType)project.getProjectType(), (String)project.getName(), (String)user.getLogin())) {
                this.deleteProjectHandler.deleteProject(project.getId(), null);
            } else {
                this.projectRecipientHandler.handle(Lists.newArrayList((Object[])new User[]{user}), (Project)project);
                this.publishUserUnassignEvent(user, loggedInUser, project.getId());
            }
        });
        this.dataStore.deleteUserPhoto(user);
        this.userRepository.delete((Object)user);
        this.sendEmailAboutDeletion(user, loggedInUser);
        return user;
    }

    private void sendEmailAboutDeletion(User user, ReportPortalUser loggedInUser) {
        EmailTemplate template = user.getId().equals(loggedInUser.getUserId()) ? EmailTemplate.USER_SELF_DELETION_NOTIFICATION : EmailTemplate.USER_DELETION_NOTIFICATION;
        this.emailNotificationStrategyMapping.get((Object)template).sendEmail(user.getEmail(), Collections.emptyMap());
    }

    @Override
    @Transactional
    public DeleteBulkRS deleteUsers(List<Long> ids, ReportPortalUser currentUser) {
        ArrayList exceptions = Lists.newArrayList();
        ArrayList deleted = Lists.newArrayList();
        ids.forEach(userId -> {
            try {
                this.deleteUserWithAssociatedData((Long)userId, currentUser);
                deleted.add(userId);
            }
            catch (ReportPortalException rp) {
                exceptions.add(rp);
            }
        });
        this.publishUsersDeletedEvent(deleted.size(), currentUser);
        return new DeleteBulkRS(deleted, Collections.emptyList(), exceptions.stream().map(ExceptionConverter.TO_ERROR_RS).collect(Collectors.toList()));
    }

    private void validateUserDeletion(Long userId, ReportPortalUser loggedInUser) {
        BusinessRule.expect((Object)(UserRole.ADMINISTRATOR.equals((Object)loggedInUser.getUserRole()) && Objects.equals(userId, loggedInUser.getUserId()) ? 1 : 0), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.ACCESS_DENIED, new Object[]{"You cannot delete own account"});
        BusinessRule.expect((Object)(UserRole.ADMINISTRATOR.equals((Object)loggedInUser.getUserRole()) || this.isAllowToDeleteAccount && loggedInUser.getUserId().equals(userId) ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.ACCESS_DENIED, new Object[]{"You are not allowed to delete account"});
    }

    private void publishUserDeletedEvent(User deletedUser, ReportPortalUser loggedInUser) {
        UserActivityResource userActivityResource = new UserActivityResource();
        userActivityResource.setId(deletedUser.getId());
        userActivityResource.setFullName(DELETED_USER);
        if (loggedInUser.getUserId().equals(deletedUser.getId())) {
            this.applicationEventPublisher.publishEvent((Object)new UserDeletedEvent(userActivityResource, loggedInUser.getUserId(), DELETED_USER));
        } else {
            this.applicationEventPublisher.publishEvent((Object)new UserDeletedEvent(userActivityResource, loggedInUser.getUserId(), loggedInUser.getUsername()));
        }
    }

    private void publishUsersDeletedEvent(int deletedCount, ReportPortalUser loggedInUser) {
        UserActivityResource userActivityResource = new UserActivityResource();
        if (deletedCount == 1) {
            userActivityResource.setFullName(deletedCount + " deleted user");
        } else {
            userActivityResource.setFullName(deletedCount + " deleted users");
        }
        this.applicationEventPublisher.publishEvent((Object)new UsersDeletedEvent(userActivityResource, loggedInUser.getUserId(), loggedInUser.getUsername()));
    }

    private void publishUserUnassignEvent(User deletedUser, ReportPortalUser authorizedUser, Long projectId) {
        UserActivityResource userActivityResource = new UserActivityResource();
        userActivityResource.setId(deletedUser.getId());
        userActivityResource.setFullName(DELETED_USER);
        userActivityResource.setDefaultProjectId(projectId);
        this.applicationEventPublisher.publishEvent((Object)new UnassignUserEvent(userActivityResource));
    }
}

