/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.user.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.auth.authenticator.UserAuthenticator;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.activity.CreateInvitationLinkEvent;
import com.epam.ta.reportportal.core.events.activity.UserCreatedEvent;
import com.epam.ta.reportportal.core.integration.GetIntegrationHandler;
import com.epam.ta.reportportal.core.project.CreateProjectHandler;
import com.epam.ta.reportportal.core.project.GetProjectHandler;
import com.epam.ta.reportportal.core.project.ProjectUserHandler;
import com.epam.ta.reportportal.core.user.CreateUserHandler;
import com.epam.ta.reportportal.dao.RestorePasswordBidRepository;
import com.epam.ta.reportportal.dao.ServerSettingsRepository;
import com.epam.ta.reportportal.dao.UserCreationBidRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.Metadata;
import com.epam.ta.reportportal.entity.ServerSettings;
import com.epam.ta.reportportal.entity.enums.IntegrationGroupEnum;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.RestorePasswordBid;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserCreationBid;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.entity.user.UserType;
import com.epam.ta.reportportal.model.YesNoRS;
import com.epam.ta.reportportal.model.activity.UserActivityResource;
import com.epam.ta.reportportal.model.user.CreateUserBidRS;
import com.epam.ta.reportportal.model.user.CreateUserRQ;
import com.epam.ta.reportportal.model.user.CreateUserRQConfirm;
import com.epam.ta.reportportal.model.user.CreateUserRQFull;
import com.epam.ta.reportportal.model.user.CreateUserRS;
import com.epam.ta.reportportal.model.user.ResetPasswordRQ;
import com.epam.ta.reportportal.model.user.RestorePasswordRQ;
import com.epam.ta.reportportal.util.Predicates;
import com.epam.ta.reportportal.util.UserUtils;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.ws.converter.builders.UserBuilder;
import com.epam.ta.reportportal.ws.converter.converters.RestorePasswordBidConverter;
import com.epam.ta.reportportal.ws.converter.converters.UserConverter;
import com.epam.ta.reportportal.ws.converter.converters.UserCreationBidConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.google.common.collect.Maps;
import jakarta.persistence.PersistenceException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CreateUserHandlerImpl
implements CreateUserHandler {
    public static final String BID_TYPE = "type";
    public static final String INTERNAL_BID_TYPE = "internal";
    private final ServerSettingsRepository settingsRepository;
    private final UserRepository userRepository;
    private final UserAuthenticator userAuthenticator;
    private final MailServiceFactory emailServiceFactory;
    private final UserCreationBidRepository userCreationBidRepository;
    private final RestorePasswordBidRepository restorePasswordBidRepository;
    private final CreateProjectHandler createProjectHandler;
    private final GetProjectHandler getProjectHandler;
    private final ProjectUserHandler projectUserHandler;
    private final GetIntegrationHandler getIntegrationHandler;
    private final ThreadPoolTaskExecutor emailExecutorService;
    private final PasswordEncoder passwordEncoder;
    private final ApplicationEventPublisher eventPublisher;

    @Override
    @Transactional
    public CreateUserRS createUserByAdmin(CreateUserRQFull request, ReportPortalUser creator, String basicUrl) {
        User administrator = (User)this.userRepository.findRawById(creator.getUserId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{creator.getUsername()}));
        BusinessRule.expect((Object)administrator.getRole(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)UserRole.ADMINISTRATOR)).verify(ErrorType.ACCESS_DENIED, new Object[]{Suppliers.formattedSupplier((String)"Only administrator can create new user. Your role is - {}", (Object[])new Object[]{administrator.getRole()})});
        this.normalize(request);
        Pair<UserActivityResource, CreateUserRS> pair = this.saveUser(request, administrator, false);
        this.emailExecutorService.execute(() -> this.emailServiceFactory.getDefaultEmailService(true).sendCreateUserConfirmationEmail(request, basicUrl));
        return (CreateUserRS)pair.getValue();
    }

    @Override
    @Transactional
    public CreateUserRS createUser(CreateUserRQConfirm request, String uuid) {
        UserCreationBid bid = (UserCreationBid)this.userCreationBidRepository.findByUuidAndType(uuid, INTERNAL_BID_TYPE).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{"Impossible to register user. UUID expired or already registered."}));
        CreateUserRQFull createUserRQFull = this.convertToCreateRequest(request, bid);
        this.normalize(createUserRQFull);
        BusinessRule.expect((Object)createUserRQFull.getEmail(), Predicate.isEqual(bid.getEmail())).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Email from bid not match."});
        User invitingUser = bid.getInvitingUser();
        Pair<UserActivityResource, CreateUserRS> pair = this.saveUser(createUserRQFull, invitingUser, true);
        this.userCreationBidRepository.deleteAllByEmail(createUserRQFull.getEmail());
        return (CreateUserRS)pair.getValue();
    }

    @Override
    public CreateUserBidRS createUserBid(CreateUserRQ request, ReportPortalUser loggedInUser, String emailURL) {
        if (this.isSsoEnabled()) {
            throw new ReportPortalException(ErrorType.ACCESS_DENIED, new Object[]{"Cannot invite user if SSO enabled."});
        }
        Project defaultProject = this.getProjectHandler.get(EntityUtils.normalizeId((String)request.getDefaultProject()));
        BusinessRule.expect((Object)this.userRepository.existsById((Object)loggedInUser.getUserId()), BooleanUtils::isTrue).verify(ErrorType.USER_NOT_FOUND, new Object[]{loggedInUser.getUsername()});
        Integration integration = this.getIntegrationHandler.getEnabledByProjectIdOrGlobalAndIntegrationGroup(defaultProject.getId(), IntegrationGroupEnum.NOTIFICATION).orElseThrow(() -> new ReportPortalException(ErrorType.EMAIL_CONFIGURATION_IS_INCORRECT, new Object[]{"Please configure email server in ReportPortal settings."}));
        String normalizedEmail = this.normalizeEmail(request.getEmail());
        request.setEmail(normalizedEmail);
        request.setRole(((ProjectRole)ProjectRole.forName((String)request.getRole()).orElseThrow(() -> new ReportPortalException(ErrorType.ROLE_NOT_FOUND, new Object[]{request.getRole()}))).name());
        UserCreationBid bid = UserCreationBidConverter.TO_USER.apply(request, defaultProject);
        bid.setMetadata(this.getUserCreationBidMetadata());
        bid.setInvitingUser((User)this.userRepository.getById((Object)loggedInUser.getUserId()));
        try {
            this.userCreationBidRepository.save((Object)bid);
        }
        catch (Exception e) {
            throw new ReportPortalException("Error while user creation bid registering.", (Throwable)e);
        }
        StringBuilder emailLink = new StringBuilder(emailURL).append("/ui/#registration?uuid=").append(bid.getUuid());
        this.emailExecutorService.execute(() -> this.emailServiceFactory.getEmailService(integration, false).sendCreateUserConfirmationEmail("User registration confirmation", new String[]{bid.getEmail()}, emailLink.toString()));
        this.eventPublisher.publishEvent((Object)new CreateInvitationLinkEvent(loggedInUser.getUserId(), loggedInUser.getUsername(), defaultProject.getId()));
        CreateUserBidRS response = new CreateUserBidRS();
        String msg = "Bid for user creation with email '" + request.getEmail() + "' is successfully registered. Confirmation info will be send on provided email. Expiration: 1 day.";
        response.setMessage(msg);
        response.setBid(bid.getUuid());
        response.setBackLink(emailLink.toString());
        return response;
    }

    @Override
    public OperationCompletionRS createRestorePasswordBid(RestorePasswordRQ rq, String baseUrl) {
        RestorePasswordBid bid;
        String email = EntityUtils.normalizeId((String)rq.getEmail());
        BusinessRule.expect((Object)UserUtils.isEmailValid((String)email), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{email});
        User user = (User)this.userRepository.findByEmail(email).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{email}));
        Optional bidOptional = this.restorePasswordBidRepository.findByEmail(rq.getEmail());
        if (bidOptional.isEmpty()) {
            BusinessRule.expect((Object)user.getUserType(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)UserType.INTERNAL)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Unable to change password for external user"});
            bid = RestorePasswordBidConverter.TO_BID.apply(rq);
            this.restorePasswordBidRepository.save((Object)bid);
        } else {
            bid = (RestorePasswordBid)bidOptional.get();
        }
        this.emailServiceFactory.getDefaultEmailService(true).sendRestorePasswordEmail("Password recovery", new String[]{email}, baseUrl + "#login?reset=" + bid.getUuid(), user.getLogin());
        return new OperationCompletionRS("Email has been sent");
    }

    @Override
    public OperationCompletionRS resetPassword(ResetPasswordRQ request) {
        RestorePasswordBid bid = (RestorePasswordBid)this.restorePasswordBidRepository.findById((Object)request.getUuid()).orElseThrow(() -> new ReportPortalException(ErrorType.ACCESS_DENIED, new Object[]{"The password change link is no longer valid."}));
        String email = bid.getEmail();
        BusinessRule.expect((Object)UserUtils.isEmailValid((String)email), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{email});
        User byEmail = (User)this.userRepository.findByEmail(email).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[0]));
        BusinessRule.expect((Object)byEmail.getUserType(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)UserType.INTERNAL)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Unable to change password for external user"});
        byEmail.setPassword(this.passwordEncoder.encode((CharSequence)request.getPassword()));
        this.userRepository.save((Object)byEmail);
        this.restorePasswordBidRepository.deleteById((Object)request.getUuid());
        OperationCompletionRS rs = new OperationCompletionRS();
        rs.setResultMessage("Password has been changed");
        return rs;
    }

    @Override
    public YesNoRS isResetPasswordBidExist(String uuid) {
        Optional bid = this.restorePasswordBidRepository.findById((Object)uuid);
        return new YesNoRS(bid.isPresent());
    }

    private boolean isSsoEnabled() {
        return this.settingsRepository.findByKey("server.users.sso").map(ServerSettings::getValue).map(Boolean::parseBoolean).orElse(false);
    }

    private void normalize(CreateUserRQFull request) {
        String login = this.normalizeLogin(request.getLogin());
        String email = this.normalizeEmail(request.getEmail());
        request.setLogin(login);
        request.setEmail(email);
    }

    private String normalizeLogin(String login) {
        String normalizedLogin = this.getNormalized(login);
        this.validateLogin(login, normalizedLogin);
        return normalizedLogin;
    }

    private void validateLogin(String original, String normalized) {
        Optional user = this.userRepository.findByLogin(normalized);
        BusinessRule.expect((Object)user.isPresent(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.USER_ALREADY_EXISTS, new Object[]{Suppliers.formattedSupplier((String)"login='{}'", (Object[])new Object[]{original})});
        BusinessRule.expect((Object)normalized, Predicates.SPECIAL_CHARS_ONLY.negate()).verify(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Username '{}' consists only of special characters", (Object[])new Object[]{original})});
    }

    private String normalizeEmail(String email) {
        String normalizedEmail = this.getNormalized(email);
        this.validateEmail(email, normalizedEmail);
        return normalizedEmail;
    }

    private void validateEmail(String original, String normalized) {
        BusinessRule.expect((Object)UserUtils.isEmailValid((String)normalized), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"email='{}'", (Object[])new Object[]{original})});
        Optional emailUser = this.userRepository.findByEmail(normalized);
        BusinessRule.expect((Object)emailUser.isPresent(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.USER_ALREADY_EXISTS, new Object[]{Suppliers.formattedSupplier((String)"email='{}'", (Object[])new Object[]{original})});
    }

    private String getNormalized(String original) {
        return EntityUtils.normalizeId((String)original.trim());
    }

    private Pair<UserActivityResource, CreateUserRS> saveUser(CreateUserRQFull request, User creator, boolean isSystemEvent) {
        User user = this.convert(request);
        try {
            this.userRepository.save((Object)user);
            UserActivityResource userActivityResource = this.getUserActivityResource(user);
            UserCreatedEvent userCreatedEvent = new UserCreatedEvent(userActivityResource, creator.getId(), creator.getLogin(), isSystemEvent);
            this.eventPublisher.publishEvent((Object)userCreatedEvent);
        }
        catch (PersistenceException pe) {
            if (pe.getCause() instanceof ConstraintViolationException) {
                BusinessRule.fail().withError(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{((ConstraintViolationException)pe.getCause()).getConstraintName()});
            }
            throw new ReportPortalException("Error while User creating: " + pe.getMessage(), (Throwable)pe);
        }
        catch (Exception exp) {
            throw new ReportPortalException("Error while User creating: " + exp.getMessage(), (Throwable)exp);
        }
        this.userAuthenticator.authenticate(user);
        Optional.ofNullable(request.getDefaultProject()).ifPresent(defaultProject -> this.assignDefaultProject(creator, user, (String)defaultProject, request.getProjectRole()));
        Project personalProject = this.createProjectHandler.createPersonal(user);
        this.projectUserHandler.assign(user, personalProject, ProjectRole.PROJECT_MANAGER, creator, isSystemEvent);
        CreateUserRS response = new CreateUserRS();
        response.setId(user.getId());
        response.setUuid(user.getUuid());
        response.setExternalId(user.getExternalId());
        response.setLogin(user.getLogin());
        response.setEmail(user.getEmail());
        response.setFullName(user.getFullName());
        response.setAccountRole(user.getRole().toString());
        response.setAccountType(user.getUserType().toString());
        response.setActive(user.getActive());
        return Pair.of((Object)UserConverter.TO_ACTIVITY_RESOURCE.apply(user, personalProject.getId()), (Object)response);
    }

    private void assignDefaultProject(User creator, User user, String defaultProject, String role) {
        Project projectToAssign = this.getProjectHandler.getRaw(EntityUtils.normalizeId((String)defaultProject));
        ProjectRole projectRole = (ProjectRole)ProjectRole.forName((String)role).orElseThrow(() -> new ReportPortalException(ErrorType.ROLE_NOT_FOUND, new Object[]{role}));
        this.projectUserHandler.assign(user, projectToAssign, projectRole, creator, false);
    }

    private UserActivityResource getUserActivityResource(User user) {
        UserActivityResource userActivityResource = new UserActivityResource();
        userActivityResource.setId(user.getId());
        userActivityResource.setFullName(user.getLogin());
        return userActivityResource;
    }

    private User convert(CreateUserRQFull request) {
        UserRole userRole = (UserRole)UserRole.findByName((String)request.getAccountRole()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Incorrect specified Account Role parameter."}));
        User user = new UserBuilder().addCreateUserFullRQ(request).addUserRole(userRole).get();
        Optional.ofNullable(request.getPassword()).ifPresent(password -> user.setPassword(this.passwordEncoder.encode((CharSequence)password)));
        return user;
    }

    private CreateUserRQFull convertToCreateRequest(CreateUserRQConfirm request, UserCreationBid bid) {
        CreateUserRQFull createUserRQFull = new CreateUserRQFull();
        createUserRQFull.setLogin(request.getLogin());
        createUserRQFull.setEmail(request.getEmail());
        createUserRQFull.setFullName(request.getFullName());
        createUserRQFull.setPassword(request.getPassword());
        createUserRQFull.setDefaultProject(bid.getProjectName());
        createUserRQFull.setAccountRole(UserRole.USER.name());
        createUserRQFull.setProjectRole(bid.getRole());
        return createUserRQFull;
    }

    private Metadata getUserCreationBidMetadata() {
        HashMap meta = Maps.newHashMapWithExpectedSize((int)1);
        meta.put(BID_TYPE, INTERNAL_BID_TYPE);
        return new Metadata((Map)meta);
    }

    @Generated
    public CreateUserHandlerImpl(ServerSettingsRepository settingsRepository, UserRepository userRepository, UserAuthenticator userAuthenticator, MailServiceFactory emailServiceFactory, UserCreationBidRepository userCreationBidRepository, RestorePasswordBidRepository restorePasswordBidRepository, CreateProjectHandler createProjectHandler, GetProjectHandler getProjectHandler, ProjectUserHandler projectUserHandler, GetIntegrationHandler getIntegrationHandler, ThreadPoolTaskExecutor emailExecutorService, PasswordEncoder passwordEncoder, ApplicationEventPublisher eventPublisher) {
        this.settingsRepository = settingsRepository;
        this.userRepository = userRepository;
        this.userAuthenticator = userAuthenticator;
        this.emailServiceFactory = emailServiceFactory;
        this.userCreationBidRepository = userCreationBidRepository;
        this.restorePasswordBidRepository = restorePasswordBidRepository;
        this.createProjectHandler = createProjectHandler;
        this.getProjectHandler = getProjectHandler;
        this.projectUserHandler = projectUserHandler;
        this.getIntegrationHandler = getIntegrationHandler;
        this.emailExecutorService = emailExecutorService;
        this.passwordEncoder = passwordEncoder;
        this.eventPublisher = eventPublisher;
    }
}

