/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.remover.user;

import com.epam.ta.reportportal.core.remover.ContentRemover;
import com.epam.ta.reportportal.core.widget.content.remover.WidgetContentRemover;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class UserWidgetRemover
implements ContentRemover<User> {
    private final WidgetRepository widgetRepository;
    private final WidgetContentRemover widgetContentRemover;

    public UserWidgetRemover(WidgetRepository widgetRepository, @Qualifier(value="delegatingStateContentRemover") WidgetContentRemover widgetContentRemover) {
        this.widgetRepository = widgetRepository;
        this.widgetContentRemover = widgetContentRemover;
    }

    @Override
    public void remove(User user) {
        List widgets = this.widgetRepository.findAllByOwnerAndWidgetTypeIn(user.getLogin(), Collections.singletonList(WidgetType.COMPONENT_HEALTH_CHECK_TABLE.getType()));
        widgets.forEach(this.widgetContentRemover::removeContent);
    }
}

