/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.settings.notification;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.NotificationsConfigUpdatedEvent;
import com.epam.ta.reportportal.core.project.settings.notification.UpdateProjectNotificationHandler;
import com.epam.ta.reportportal.core.project.validator.notification.ProjectNotificationValidator;
import com.epam.ta.reportportal.dao.SenderCaseRepository;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.email.SenderCase;
import com.epam.ta.reportportal.model.project.ProjectResource;
import com.epam.ta.reportportal.model.project.email.ProjectNotificationConfigDTO;
import com.epam.ta.reportportal.model.project.email.SenderCaseDTO;
import com.epam.ta.reportportal.ws.converter.converters.NotificationConfigConverter;
import com.epam.ta.reportportal.ws.converter.converters.ProjectConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class UpdateProjectNotificationHandlerImpl
implements UpdateProjectNotificationHandler {
    private final SenderCaseRepository senderCaseRepository;
    private final MessageBus messageBus;
    private final ProjectConverter projectConverter;
    private final ProjectNotificationValidator projectNotificationValidator;

    public UpdateProjectNotificationHandlerImpl(SenderCaseRepository senderCaseRepository, MessageBus messageBus, ProjectConverter projectConverter, ProjectNotificationValidator projectNotificationValidator) {
        this.senderCaseRepository = senderCaseRepository;
        this.messageBus = messageBus;
        this.projectConverter = projectConverter;
        this.projectNotificationValidator = projectNotificationValidator;
    }

    @Override
    public OperationCompletionRS updateNotification(Project project, SenderCaseDTO updateNotificationRQ, ReportPortalUser user) {
        BusinessRule.expect((Object)updateNotificationRQ.getId(), Objects::nonNull).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Please specify notification Id"});
        BusinessRule.expect((Object)this.senderCaseRepository.findById((Object)updateNotificationRQ.getId()), notification -> notification.map(ntf -> Objects.equals(ntf.getProject().getId(), project.getId())).orElse(false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Notification '{}' not found. Did you use correct Notification ID?", (Object[])new Object[]{updateNotificationRQ.getId()}).get()});
        this.projectNotificationValidator.validateUpdateRQ(project, updateNotificationRQ);
        SenderCase notification2 = NotificationConfigConverter.TO_CASE_MODEL.apply(updateNotificationRQ);
        notification2.setProject(project);
        this.senderCaseRepository.save((Object)notification2);
        ProjectResource projectResource = this.projectConverter.TO_PROJECT_RESOURCE.apply(project);
        ProjectNotificationConfigDTO projectNotificationConfigDTO = projectResource.getConfiguration().getProjectConfig();
        projectNotificationConfigDTO.getSenderCases().add(updateNotificationRQ);
        this.messageBus.publishActivity(new NotificationsConfigUpdatedEvent(projectResource, projectResource.getConfiguration().getProjectConfig(), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("Notification rule was updated successfully.");
    }
}

