/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.settings.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.DefectTypeUpdatedEvent;
import com.epam.ta.reportportal.core.events.activity.PatternUpdatedEvent;
import com.epam.ta.reportportal.core.project.settings.UpdateProjectSettingsHandler;
import com.epam.ta.reportportal.dao.PatternTemplateRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.entity.pattern.PatternTemplate;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectIssueType;
import com.epam.ta.reportportal.model.activity.IssueTypeActivityResource;
import com.epam.ta.reportportal.model.activity.PatternTemplateActivityResource;
import com.epam.ta.reportportal.model.project.config.UpdateIssueSubTypeRQ;
import com.epam.ta.reportportal.model.project.config.UpdateOneIssueSubTypeRQ;
import com.epam.ta.reportportal.model.project.config.pattern.UpdatePatternTemplateRQ;
import com.epam.ta.reportportal.ws.converter.converters.IssueTypeConverter;
import com.epam.ta.reportportal.ws.converter.converters.PatternTemplateConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UpdateProjectSettingsHandlerImpl
implements UpdateProjectSettingsHandler {
    private final ProjectRepository projectRepository;
    private final PatternTemplateRepository patternTemplateRepository;
    private final MessageBus messageBus;

    @Autowired
    public UpdateProjectSettingsHandlerImpl(ProjectRepository projectRepository, PatternTemplateRepository patternTemplateRepository, MessageBus messageBus) {
        this.projectRepository = projectRepository;
        this.patternTemplateRepository = patternTemplateRepository;
        this.messageBus = messageBus;
    }

    @Override
    public OperationCompletionRS updateProjectIssueSubType(String projectName, ReportPortalUser user, UpdateIssueSubTypeRQ updateIssueSubTypeRQ) {
        BusinessRule.expect((Object)(updateIssueSubTypeRQ.getIds().size() > 0 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Please specify at least one item data for update."});
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        List<IssueTypeActivityResource> issueTypeActivityResources = updateIssueSubTypeRQ.getIds().stream().map(subTypeRQ -> IssueTypeConverter.TO_ACTIVITY_RESOURCE.apply(this.validateAndUpdate((UpdateOneIssueSubTypeRQ)subTypeRQ, project.getProjectIssueTypes().stream().map(ProjectIssueType::getIssueType).collect(Collectors.toList())))).collect(Collectors.toList());
        this.projectRepository.save((Object)project);
        issueTypeActivityResources.forEach(it -> this.messageBus.publishActivity(new DefectTypeUpdatedEvent((IssueTypeActivityResource)it, user.getUserId(), user.getUsername(), project.getId())));
        return new OperationCompletionRS("Issue sub-type(s) was updated successfully.");
    }

    @Override
    public OperationCompletionRS updatePatternTemplate(Long id, String projectName, UpdatePatternTemplateRQ updatePatternTemplateRQ, ReportPortalUser user) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        PatternTemplate patternTemplate = (PatternTemplate)this.patternTemplateRepository.findById((Object)id).orElseThrow(() -> new ReportPortalException(ErrorType.PATTERN_TEMPLATE_NOT_FOUND_IN_PROJECT, new Object[]{id, project.getId()}));
        String name = StringUtils.trim((String)updatePatternTemplateRQ.getName());
        if (!patternTemplate.getName().equalsIgnoreCase(name)) {
            BusinessRule.expect((Object)this.patternTemplateRepository.existsByProjectIdAndNameIgnoreCase(project.getId(), name), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{name});
        }
        PatternTemplateActivityResource before = PatternTemplateConverter.TO_ACTIVITY_RESOURCE.apply(patternTemplate);
        patternTemplate.setName(name);
        patternTemplate.setEnabled(updatePatternTemplateRQ.getEnabled().booleanValue());
        PatternTemplateActivityResource after = PatternTemplateConverter.TO_ACTIVITY_RESOURCE.apply(patternTemplate);
        this.messageBus.publishActivity(new PatternUpdatedEvent(user.getUserId(), user.getUsername(), before, after));
        return new OperationCompletionRS((String)Suppliers.formattedSupplier((String)"Pattern template with ID = '{}' has been successfully updated", (Object[])new Object[]{id}).get());
    }

    private IssueType validateAndUpdate(UpdateOneIssueSubTypeRQ issueSubTypeRQ, List<IssueType> issueTypes) {
        TestItemIssueGroup expectedGroup = (TestItemIssueGroup)TestItemIssueGroup.fromValue((String)issueSubTypeRQ.getTypeRef()).orElseThrow(() -> new ReportPortalException(ErrorType.ISSUE_TYPE_NOT_FOUND, new Object[]{issueSubTypeRQ.getTypeRef()}));
        IssueType exist = issueTypes.stream().filter(issueType -> issueType.getLocator().equalsIgnoreCase(issueSubTypeRQ.getLocator())).findFirst().orElseThrow(() -> new ReportPortalException(ErrorType.ISSUE_TYPE_NOT_FOUND, new Object[]{issueSubTypeRQ.getLocator()}));
        BusinessRule.expect((Object)exist.getIssueGroup().getTestItemIssueGroup().equals((Object)expectedGroup), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"You cannot change sub-type references to global type."});
        BusinessRule.expect((Object)exist.getLocator(), (Predicate)Predicates.not((Predicate)Predicates.in((Collection)Sets.newHashSet((Object[])new String[]{TestItemIssueGroup.AUTOMATION_BUG.getLocator(), TestItemIssueGroup.PRODUCT_BUG.getLocator(), TestItemIssueGroup.SYSTEM_ISSUE.getLocator(), TestItemIssueGroup.NO_DEFECT.getLocator(), TestItemIssueGroup.TO_INVESTIGATE.getLocator()})))).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"You cannot remove predefined global issue types."});
        Optional.ofNullable(issueSubTypeRQ.getLongName()).ifPresent(arg_0 -> ((IssueType)exist).setLongName(arg_0));
        Optional.ofNullable(issueSubTypeRQ.getShortName()).ifPresent(arg_0 -> ((IssueType)exist).setShortName(arg_0));
        Optional.ofNullable(issueSubTypeRQ.getColor()).ifPresent(arg_0 -> ((IssueType)exist).setHexColor(arg_0));
        return exist;
    }
}

