/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.impl;

import com.epam.reportportal.extension.event.ProjectEvent;
import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.auto.indexer.IndexerStatusCache;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.AssignUserEvent;
import com.epam.ta.reportportal.core.events.activity.ChangeRoleEvent;
import com.epam.ta.reportportal.core.events.activity.NotificationsConfigUpdatedEvent;
import com.epam.ta.reportportal.core.events.activity.ProjectAnalyzerConfigEvent;
import com.epam.ta.reportportal.core.events.activity.ProjectIndexEvent;
import com.epam.ta.reportportal.core.events.activity.ProjectPatternAnalyzerUpdateEvent;
import com.epam.ta.reportportal.core.events.activity.ProjectUpdatedEvent;
import com.epam.ta.reportportal.core.events.activity.UnassignUserEvent;
import com.epam.ta.reportportal.core.events.activity.util.ActivityDetailsUtil;
import com.epam.ta.reportportal.core.project.UpdateProjectHandler;
import com.epam.ta.reportportal.core.project.validator.attribute.ProjectAttributeValidator;
import com.epam.ta.reportportal.dao.AttributeRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.ProjectUserRepository;
import com.epam.ta.reportportal.dao.UserPreferenceRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.attribute.Attribute;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.enums.ProjectType;
import com.epam.ta.reportportal.entity.enums.SendCase;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectAttribute;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.entity.user.ProjectUser;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.entity.user.UserType;
import com.epam.ta.reportportal.model.activity.ProjectAttributesActivityResource;
import com.epam.ta.reportportal.model.activity.UserActivityResource;
import com.epam.ta.reportportal.model.project.AssignUsersRQ;
import com.epam.ta.reportportal.model.project.ProjectResource;
import com.epam.ta.reportportal.model.project.UnassignUsersRQ;
import com.epam.ta.reportportal.model.project.UpdateProjectRQ;
import com.epam.ta.reportportal.model.project.config.ProjectConfigurationUpdate;
import com.epam.ta.reportportal.model.project.email.ProjectNotificationConfigDTO;
import com.epam.ta.reportportal.model.project.email.SenderCaseDTO;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.util.email.EmailRulesValidator;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.ws.converter.converters.NotificationConfigConverter;
import com.epam.ta.reportportal.ws.converter.converters.ProjectActivityConverter;
import com.epam.ta.reportportal.ws.converter.converters.ProjectConverter;
import com.epam.ta.reportportal.ws.converter.converters.UserConverter;
import com.epam.ta.reportportal.ws.reporting.ItemAttributeResource;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class UpdateProjectHandlerImpl
implements UpdateProjectHandler {
    private static final String UPDATE_EVENT = "update";
    private final ProjectExtractor projectExtractor;
    private final ProjectAttributeValidator projectAttributeValidator;
    private final ProjectRepository projectRepository;
    private final UserRepository userRepository;
    private final AttributeRepository attributeRepository;
    private final UserPreferenceRepository preferenceRepository;
    private final ProjectUserRepository projectUserRepository;
    private final MessageBus messageBus;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final MailServiceFactory mailServiceFactory;
    private final AnalyzerStatusCache analyzerStatusCache;
    private final IndexerStatusCache indexerStatusCache;
    private final AnalyzerServiceClient analyzerServiceClient;
    private final LogIndexer logIndexer;
    private final ProjectConverter projectConverter;

    @Autowired
    public UpdateProjectHandlerImpl(ProjectExtractor projectExtractor, ProjectAttributeValidator projectAttributeValidator, ProjectRepository projectRepository, UserRepository userRepository, UserPreferenceRepository preferenceRepository, MessageBus messageBus, ProjectUserRepository projectUserRepository, ApplicationEventPublisher applicationEventPublisher, MailServiceFactory mailServiceFactory, AnalyzerStatusCache analyzerStatusCache, IndexerStatusCache indexerStatusCache, AnalyzerServiceClient analyzerServiceClient, LogIndexer logIndexer, ProjectConverter projectConverter, AttributeRepository attributeRepository) {
        this.projectExtractor = projectExtractor;
        this.projectAttributeValidator = projectAttributeValidator;
        this.projectRepository = projectRepository;
        this.userRepository = userRepository;
        this.preferenceRepository = preferenceRepository;
        this.messageBus = messageBus;
        this.projectUserRepository = projectUserRepository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.mailServiceFactory = mailServiceFactory;
        this.analyzerStatusCache = analyzerStatusCache;
        this.indexerStatusCache = indexerStatusCache;
        this.analyzerServiceClient = analyzerServiceClient;
        this.logIndexer = logIndexer;
        this.projectConverter = projectConverter;
        this.attributeRepository = attributeRepository;
    }

    @Override
    public OperationCompletionRS updateProject(String projectName, UpdateProjectRQ updateProjectRQ, ReportPortalUser user) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        ProjectAttributesActivityResource before = ProjectActivityConverter.TO_ACTIVITY_RESOURCE.apply(project);
        this.updateProjectConfiguration(updateProjectRQ.getConfiguration(), project);
        Optional.ofNullable(updateProjectRQ.getUserRoles()).ifPresent(roles -> this.updateProjectUserRoles((Map<String, String>)roles, project, user));
        this.projectRepository.save((Object)project);
        ProjectAttributesActivityResource after = ProjectActivityConverter.TO_ACTIVITY_RESOURCE.apply(project);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProjectEvent(project.getId(), UPDATE_EVENT));
        this.publishUpdatedAttributesActivities(before, after, user, updateProjectRQ.getConfiguration());
        return new OperationCompletionRS("Project with name = '" + project.getName() + "' is successfully updated.");
    }

    @Override
    public OperationCompletionRS updateProjectNotificationConfig(String projectName, ReportPortalUser user, ProjectNotificationConfigDTO updateProjectNotificationConfigRQ) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        ProjectResource before = this.projectConverter.TO_PROJECT_RESOURCE.apply(project);
        this.updateSenderCases(project, updateProjectNotificationConfigRQ.getSenderCases());
        project.getProjectAttributes().stream().filter(it -> it.getAttribute().getName().equalsIgnoreCase(ProjectAttributeEnum.NOTIFICATIONS_ENABLED.getAttribute())).findAny().ifPresent(pa -> pa.setValue(String.valueOf(updateProjectNotificationConfigRQ.isEnabled())));
        this.messageBus.publishActivity(new NotificationsConfigUpdatedEvent(before, updateProjectNotificationConfigRQ, user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("Notification configuration of project - '" + projectName + "' is successfully updated.");
    }

    @Override
    public OperationCompletionRS unassignUsers(String projectName, UnassignUsersRQ unassignUsersRQ, ReportPortalUser user) {
        BusinessRule.expect(unassignUsersRQ.getUsernames(), (Predicate)Predicates.not(List::isEmpty)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Request should contain at least one username."});
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        User modifier = (User)this.userRepository.findById((Object)user.getUserId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{user.getUsername()}));
        if (!UserRole.ADMINISTRATOR.equals((Object)modifier.getRole())) {
            BusinessRule.expect(unassignUsersRQ.getUsernames(), (Predicate)Predicates.not((Predicate)Preconditions.contains((Predicate)Predicates.equalTo((Object)modifier.getLogin())))).verify(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"User should not unassign himself from project."});
        }
        List<ProjectUser> unassignedUsers = this.unassignUsers(unassignUsersRQ.getUsernames(), modifier, project, user);
        this.projectUserRepository.deleteAll(unassignedUsers);
        ProjectUtils.excludeProjectRecipients((Iterable)unassignedUsers.stream().map(ProjectUser::getUser).collect(Collectors.toSet()), (Project)project);
        unassignedUsers.forEach(it -> this.preferenceRepository.removeByProjectIdAndUserId(project.getId(), it.getUser().getId()));
        return new OperationCompletionRS("User(s) with username(s)='" + String.valueOf(unassignUsersRQ.getUsernames()) + "' was successfully un-assigned from project='" + project.getName() + "'");
    }

    @Override
    public OperationCompletionRS assignUsers(String projectName, AssignUsersRQ assignUsersRQ, ReportPortalUser user) {
        if (UserRole.ADMINISTRATOR.equals((Object)user.getUserRole())) {
            Project project = (Project)this.projectRepository.findByName(EntityUtils.normalizeId((String)projectName)).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{EntityUtils.normalizeId((String)projectName)}));
            List assignedUsernames = project.getUsers().stream().map(u -> u.getUser().getLogin()).collect(Collectors.toList());
            assignUsersRQ.getUserNames().forEach((name, role) -> {
                ProjectRole projectRole = (ProjectRole)ProjectRole.forName((String)role).orElseThrow(() -> new ReportPortalException(ErrorType.ROLE_NOT_FOUND, new Object[]{role}));
                this.assignUser((String)name, projectRole, assignedUsernames, project, user);
            });
        } else {
            BusinessRule.expect(assignUsersRQ.getUserNames().keySet(), (Predicate)Predicates.not((Predicate)Preconditions.contains((Predicate)Predicates.equalTo((Object)user.getUsername())))).verify(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"User should not assign himself to project."});
            ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetails(user, projectName);
            Project project = (Project)this.projectRepository.findById((Object)projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{EntityUtils.normalizeId((String)projectName)}));
            List assignedUsernames = project.getUsers().stream().map(u -> u.getUser().getLogin()).collect(Collectors.toList());
            assignUsersRQ.getUserNames().forEach((name, role) -> {
                ProjectRole projectRole = (ProjectRole)ProjectRole.forName((String)role).orElseThrow(() -> new ReportPortalException(ErrorType.ROLE_NOT_FOUND, new Object[]{role}));
                ProjectRole modifierRole = projectDetails.getProjectRole();
                BusinessRule.expect((Object)modifierRole.sameOrHigherThan(projectRole), BooleanUtils::isTrue).verify(ErrorType.ACCESS_DENIED, new Object[0]);
                this.assignUser((String)name, projectRole, assignedUsernames, project, user);
            });
        }
        return new OperationCompletionRS("User(s) with username='" + String.valueOf(assignUsersRQ.getUserNames().keySet()) + "' was successfully assigned to project='" + EntityUtils.normalizeId((String)projectName) + "'");
    }

    @Override
    public OperationCompletionRS indexProjectData(String projectName, ReportPortalUser user) {
        BusinessRule.expect((Object)this.analyzerServiceClient.hasClients(), Predicate.isEqual(true)).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"There are no analyzer deployed."});
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        BusinessRule.expect((Object)Optional.ofNullable((Boolean)this.indexerStatusCache.getIndexingStatus().getIfPresent((Object)project.getId())).orElse(false), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Index can not be removed until index generation proceeds."});
        Cache<Long, Long> analyzeStatus = this.analyzerStatusCache.getAnalyzeStatus("autoAnalyzer").orElseThrow(() -> new ReportPortalException(ErrorType.ANALYZER_NOT_FOUND, new Object[]{"autoAnalyzer"}));
        BusinessRule.expect((Object)analyzeStatus.asMap().containsValue(project.getId()), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Index can not be removed until auto-analysis proceeds."});
        this.logIndexer.deleteIndex(project.getId());
        this.logIndexer.index(project.getId(), AnalyzerUtils.getAnalyzerConfig(project)).thenAcceptAsync(indexedCount -> this.mailServiceFactory.getDefaultEmailService(true).sendIndexFinishedEmail("Index generation has been finished", user.getEmail(), (Long)indexedCount));
        this.messageBus.publishActivity(new ProjectIndexEvent(user.getUserId(), user.getUsername(), project.getId(), project.getName(), true));
        return new OperationCompletionRS("Log indexing has been started");
    }

    private List<ProjectUser> unassignUsers(List<String> usernames, User modifier, Project project, ReportPortalUser user) {
        ArrayList unassignedUsers = Lists.newArrayListWithExpectedSize((int)usernames.size());
        if (modifier.getRole() == UserRole.ADMINISTRATOR) {
            usernames.forEach(username -> {
                User userForUnassign = (User)this.userRepository.findByLogin(username).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{username}));
                this.validateUnassigningUser(modifier, userForUnassign, project.getId(), project);
                unassignedUsers.add(this.unassignUser(project, (String)username, userForUnassign, user));
            });
        } else {
            ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetails(user, project.getName());
            usernames.forEach(username -> {
                User userForUnassign = (User)this.userRepository.findByLogin(username).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{username}));
                ProjectUser projectUser = userForUnassign.getProjects().stream().filter(it -> Objects.equals(it.getProject().getId(), project.getId())).findFirst().orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{userForUnassign.getLogin(), String.format("User not found in project %s", project.getName())}));
                BusinessRule.expect((Object)projectDetails.getProjectRole().sameOrHigherThan(projectUser.getProjectRole()), BooleanUtils::isTrue).verify(ErrorType.ACCESS_DENIED, new Object[0]);
                this.validateUnassigningUser(modifier, userForUnassign, project.getId(), project);
                unassignedUsers.add(this.unassignUser(project, (String)username, userForUnassign, user));
            });
        }
        return unassignedUsers;
    }

    private ProjectUser unassignUser(Project project, String username, User userForUnassign, ReportPortalUser authorizedUser) {
        ProjectUser projectUser = project.getUsers().stream().filter(it -> it.getUser().getLogin().equalsIgnoreCase(username)).findFirst().orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{username}));
        project.getUsers().remove(projectUser);
        userForUnassign.getProjects().remove(projectUser);
        UnassignUserEvent unassignUserEvent = new UnassignUserEvent(this.convertUserToResource(userForUnassign, projectUser), authorizedUser.getUserId(), authorizedUser.getUsername());
        this.applicationEventPublisher.publishEvent((Object)unassignUserEvent);
        return projectUser;
    }

    private UserActivityResource convertUserToResource(User user, ProjectUser projectUser) {
        Long projectId = projectUser.getProject().getId();
        return UserConverter.TO_ACTIVITY_RESOURCE.apply(user, projectId);
    }

    private void assignUser(String name, ProjectRole projectRole, List<String> assignedUsernames, Project project, ReportPortalUser authorizedUser) {
        User modifyingUser = (User)this.userRepository.findByLogin(EntityUtils.normalizeId((String)name)).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{name}));
        BusinessRule.expect((Object)name, (Predicate)Predicates.not((Predicate)Predicates.in(assignedUsernames))).verify(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{Suppliers.formattedSupplier((String)"User '{}' cannot be assigned to project twice.", (Object[])new Object[]{name})});
        if (ProjectType.UPSA.equals((Object)project.getProjectType()) && UserType.UPSA.equals((Object)modifyingUser.getUserType())) {
            BusinessRule.fail().withError(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"Please verify user assignment to the project in EPAM internal system: delivery.epam.com"});
        }
        ProjectUser projectUser = new ProjectUser();
        projectUser.setProjectRole(projectRole);
        projectUser.setUser(modifyingUser);
        projectUser.setProject(project);
        project.getUsers().add(projectUser);
        AssignUserEvent assignUserEvent = new AssignUserEvent(this.convertUserToResource(modifyingUser, projectUser), authorizedUser.getUserId(), authorizedUser.getUsername(), false);
        this.applicationEventPublisher.publishEvent((Object)assignUserEvent);
    }

    private void validateUnassigningUser(User modifier, User userForUnassign, Long projectId, Project project) {
        if (ProjectUtils.isPersonalForUser((ProjectType)project.getProjectType(), (String)project.getName(), (String)userForUnassign.getLogin())) {
            BusinessRule.fail().withError(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"Unable to unassign user from his personal project"});
        }
        if (ProjectType.UPSA.equals((Object)project.getProjectType()) && UserType.UPSA.equals((Object)userForUnassign.getUserType())) {
            BusinessRule.fail().withError(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"Please verify user assignment to the project in EPAM internal system: delivery.epam.com"});
        }
        if (!ProjectUtils.doesHaveUser((Project)project, (String)userForUnassign.getLogin())) {
            BusinessRule.fail().withError(ErrorType.USER_NOT_FOUND, new Object[]{userForUnassign.getLogin(), String.format("User not found in project %s", project.getName())});
        }
    }

    private void updateProjectUserRoles(Map<String, String> userRoles, Project project, ReportPortalUser user) {
        if (!user.getUserRole().equals((Object)UserRole.ADMINISTRATOR)) {
            BusinessRule.expect((Object)userRoles.get(user.getUsername()), (Predicate)Predicates.isNull()).verify(ErrorType.UNABLE_TO_UPDATE_YOURSELF_ROLE, new Object[]{user.getUsername()});
        }
        if (MapUtils.isNotEmpty(userRoles)) {
            userRoles.forEach((key, value) -> {
                Optional newProjectRole = ProjectRole.forName((String)value);
                BusinessRule.expect((Object)newProjectRole, (Predicate)Predicates.isPresent()).verify(ErrorType.ROLE_NOT_FOUND, new Object[]{value});
                Optional<ProjectUser> updatingProjectUser = Optional.ofNullable(ProjectUtils.findUserConfigByLogin((Project)project, (String)key));
                BusinessRule.expect(updatingProjectUser, (Predicate)Predicates.isPresent()).verify(ErrorType.USER_NOT_FOUND, new Object[]{key});
                if (UserRole.ADMINISTRATOR != user.getUserRole()) {
                    ProjectRole updatingUserRole;
                    ProjectRole principalRole = this.projectExtractor.extractProjectDetails(user, project.getName()).getProjectRole();
                    if (principalRole.sameOrHigherThan(updatingUserRole = Optional.ofNullable(ProjectUtils.findUserConfigByLogin((Project)project, (String)key)).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{key})).getProjectRole())) {
                        BusinessRule.expect((Object)((ProjectRole)newProjectRole.get()), (Predicate)Preconditions.isLevelEnough((ProjectRole)principalRole)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
                    } else {
                        BusinessRule.expect((Object)updatingUserRole, (Predicate)Preconditions.isLevelEnough((ProjectRole)principalRole)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
                    }
                }
                String oldRole = updatingProjectUser.get().getProjectRole().getRoleName();
                updatingProjectUser.get().setProjectRole((ProjectRole)newProjectRole.get());
                this.publishChangeRoleEvent(user, updatingProjectUser.get(), oldRole);
            });
        }
    }

    private void publishChangeRoleEvent(ReportPortalUser loggedUser, ProjectUser updatingProjectUser, String oldRole) {
        String newRole = updatingProjectUser.getProjectRole().getRoleName();
        ChangeRoleEvent changeRoleEvent = this.getChangeRoleEvent(updatingProjectUser.getUser(), updatingProjectUser.getProject().getId(), loggedUser, oldRole, newRole);
        this.applicationEventPublisher.publishEvent((Object)changeRoleEvent);
    }

    private ChangeRoleEvent getChangeRoleEvent(User updatingUser, Long projectId, ReportPortalUser loggedUser, String oldRole, String newRole) {
        UserActivityResource userActivityResource = new UserActivityResource(updatingUser.getId(), projectId, updatingUser.getLogin());
        return new ChangeRoleEvent(userActivityResource, oldRole, newRole, loggedUser.getUserId(), loggedUser.getUsername());
    }

    private void updateProjectConfiguration(ProjectConfigurationUpdate configuration, Project project) {
        Optional.ofNullable(configuration).flatMap(config -> Optional.ofNullable(config.getProjectAttributes())).ifPresent(attributes -> {
            this.projectAttributeValidator.verifyProjectAttributes(ProjectUtils.getConfigParameters((Set)project.getProjectAttributes()), (Map<String, String>)attributes);
            attributes.forEach((attribute, value) -> {
                Optional<ProjectAttribute> existingAttribute = project.getProjectAttributes().stream().filter(it -> it.getAttribute().getName().equalsIgnoreCase((String)attribute)).findFirst();
                if (existingAttribute.isPresent()) {
                    existingAttribute.get().setValue(value);
                } else {
                    Optional attributeOptional = this.attributeRepository.findByName(attribute);
                    if (attributeOptional.isPresent()) {
                        ProjectAttribute newAttribute = new ProjectAttribute();
                        newAttribute.setAttribute((Attribute)attributeOptional.get());
                        newAttribute.setValue(value);
                        newAttribute.setProject(project);
                        project.getProjectAttributes().add(newAttribute);
                    }
                }
            });
        });
    }

    private void updateSenderCases(Project project, List<SenderCaseDTO> cases) {
        project.getSenderCases().clear();
        if (CollectionUtils.isNotEmpty(cases)) {
            cases.forEach(sendCase -> this.validateSenderCase((SenderCaseDTO)sendCase, project));
            Set withoutDuplicateCases = cases.stream().distinct().map(NotificationConfigConverter.TO_CASE_MODEL).peek(sc -> sc.setProject(project)).collect(Collectors.toSet());
            if (cases.size() != withoutDuplicateCases.size()) {
                BusinessRule.fail().withError(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Project notification settings contain duplicate cases for this communication channel"});
            }
            project.getSenderCases().addAll(withoutDuplicateCases);
        }
    }

    private void validateSenderCase(SenderCaseDTO sendCase, Project project) {
        BusinessRule.expect((Object)SendCase.findByName((String)sendCase.getSendCase()).isPresent(), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{sendCase.getSendCase()});
        BusinessRule.expect(sendCase.getRecipients(), (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Recipients list should not be null"});
        BusinessRule.expect((Object)sendCase.getRecipients().isEmpty(), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Empty recipients list for case '{}' ", (Object[])new Object[]{sendCase})});
        sendCase.setRecipients(sendCase.getRecipients().stream().map(it -> {
            EmailRulesValidator.validateRecipient(project, it);
            return it.trim();
        }).distinct().collect(Collectors.toList()));
        Optional.ofNullable(sendCase.getLaunchNames()).ifPresent(launchNames -> sendCase.setLaunchNames(launchNames.stream().map(name -> {
            EmailRulesValidator.validateLaunchName(name);
            return name.trim();
        }).distinct().collect(Collectors.toList())));
        Optional.ofNullable(sendCase.getAttributes()).ifPresent(attributes -> sendCase.setAttributes(attributes.stream().peek(attribute -> {
            EmailRulesValidator.validateLaunchAttribute(attribute);
            this.cutAttributeToMaxLength((ItemAttributeResource)attribute);
            attribute.setValue(attribute.getValue().trim());
        }).collect(Collectors.toSet())));
    }

    private void cutAttributeToMaxLength(ItemAttributeResource entity) {
        String key = entity.getKey();
        String value = entity.getValue();
        if (key != null && key.length() > 512) {
            entity.setKey(key.substring(0, 512));
        }
        if (value != null && value.length() > 512) {
            entity.setValue(value.substring(0, 512));
        }
    }

    private void publishUpdatedAttributesActivities(ProjectAttributesActivityResource before, ProjectAttributesActivityResource after, ReportPortalUser user, ProjectConfigurationUpdate updateConfiguration) {
        if (ActivityDetailsUtil.configChanged(before.getConfig(), after.getConfig(), "job.")) {
            this.applicationEventPublisher.publishEvent((Object)new ProjectUpdatedEvent(before, after, user.getUserId(), user.getUsername()));
        }
        if (ActivityDetailsUtil.configChanged(before.getConfig(), after.getConfig(), "analyzer.")) {
            if (ActivityDetailsUtil.extractConfigByPrefix(updateConfiguration.getProjectAttributes(), ProjectAttributeEnum.AUTO_PATTERN_ANALYZER_ENABLED.getAttribute()).isEmpty()) {
                this.applicationEventPublisher.publishEvent((Object)new ProjectAnalyzerConfigEvent(before, after, user.getUserId(), user.getUsername()));
            } else {
                this.applicationEventPublisher.publishEvent((Object)new ProjectPatternAnalyzerUpdateEvent(before, after, user.getUserId(), user.getUsername()));
            }
        }
    }
}

