/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.impl;

import com.epam.ta.reportportal.core.statistics.StatisticsHelper;
import com.epam.ta.reportportal.entity.enums.InfoInterval;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.statistics.Statistics;
import com.epam.ta.reportportal.model.widget.ChartObject;
import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="projectInfoDataConverter")
public class ProjectInfoWidgetDataConverter {
    private Map<InfoInterval, ProjectInfoGroup> grouping;
    private static DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendValue(IsoFields.WEEK_BASED_YEAR, 4).appendLiteral("-W").appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 2).toFormatter();

    @Autowired
    public ProjectInfoWidgetDataConverter(@Qualifier(value="groupingStrategy") Map<InfoInterval, ProjectInfoGroup> grouping) {
        this.grouping = grouping;
    }

    public Map<String, List<ChartObject>> getInvestigatedProjectInfo(List<Launch> initial, InfoInterval interval) {
        if (initial.isEmpty()) {
            return new HashMap<String, List<ChartObject>>();
        }
        DecimalFormat formatter = new DecimalFormat("###.##");
        String INV = "investigated";
        String TI = "toInvestigate";
        HashMap<String, List<ChartObject>> result = new HashMap<String, List<ChartObject>>();
        Map<String, List<Launch>> grouped = ProjectInfoWidgetDataConverter.groupBy(initial, this.grouping.get(interval));
        for (Map.Entry<String, List<Launch>> pair : grouped.entrySet()) {
            double investigated = 0.0;
            double toInvestigate = 0.0;
            List<Launch> group = pair.getValue();
            ChartObject currentGroup = new ChartObject();
            currentGroup.setName(pair.getKey());
            HashMap<String, String> values = new HashMap<String, String>();
            for (Launch one : group) {
                investigated = investigated + (double)StatisticsHelper.extractStatisticsCount("statistics$defects$product_bug$total", one.getStatistics()).intValue() + (double)StatisticsHelper.extractStatisticsCount("statistics$defects$system_issue$total", one.getStatistics()).intValue() + (double)StatisticsHelper.extractStatisticsCount("statistics$defects$automation_bug$total", one.getStatistics()).intValue();
                toInvestigate += (double)StatisticsHelper.extractStatisticsCount("statistics$defects$to_investigate$total", one.getStatistics()).intValue();
            }
            if (investigated + toInvestigate > 0.0) {
                double investigatedPercent = investigated / (investigated + toInvestigate) * 100.0;
                double toInvestigatePercent = 100.0 - investigatedPercent;
                values.put("investigated", formatter.format(investigatedPercent));
                values.put("toInvestigate", formatter.format(toInvestigatePercent));
            } else {
                values.put("investigated", "0");
                values.put("toInvestigate", "0");
            }
            currentGroup.setValues(values);
            result.put(pair.getKey(), Collections.singletonList(currentGroup));
        }
        return result;
    }

    public Map<String, List<ChartObject>> getTestCasesStatisticsProjectInfo(List<Launch> initial) {
        DecimalFormat formatter = new DecimalFormat("#####.##");
        String MIN = "min";
        String MAX = "max";
        String AVG = "avg";
        String globalAverageSeria = "Median value in all unique launches";
        if (initial.isEmpty()) {
            return new HashMap<String, List<ChartObject>>();
        }
        HashMap<String, List<ChartObject>> result = new HashMap<String, List<ChartObject>>();
        Map<String, List<Launch>> grouped = ProjectInfoWidgetDataConverter.groupBy(initial, ProjectInfoGroup.BY_NAME);
        for (Map.Entry<String, List<Launch>> pair : grouped.entrySet()) {
            ChartObject singleStat = new ChartObject();
            singleStat.setName(pair.getKey());
            HashMap<String, String> values = new HashMap<String, String>();
            List<Launch> group = pair.getValue();
            DoubleSummaryStatistics statistics = group.stream().mapToDouble(launch -> launch.getStatistics().stream().filter(it -> it.getStatisticsField().getName().equalsIgnoreCase("statistics$executions$total")).findFirst().orElse(new Statistics()).getCounter()).summaryStatistics();
            values.put("min", String.valueOf(statistics.getMin()));
            values.put("max", String.valueOf(statistics.getMax()));
            values.put("avg", formatter.format(statistics.getAverage()));
            singleStat.setValues(values);
            result.put(pair.getKey(), Collections.singletonList(singleStat));
        }
        result.put(globalAverageSeria, Collections.singletonList(new ChartObject()));
        return result;
    }

    public Map<String, List<ChartObject>> getLaunchesQuantity(List<Launch> initial, InfoInterval interval) {
        String START_PERIOD = "start";
        String END_PERIOD = "end";
        String COUNT = "count";
        String INTERVAL = "interval";
        HashMap<String, List<ChartObject>> result = new HashMap<String, List<ChartObject>>();
        if (initial.isEmpty()) {
            return result;
        }
        ProjectInfoGroup criteria = this.grouping.get(interval);
        Map<String, List<Launch>> grouped = ProjectInfoWidgetDataConverter.groupBy(initial, criteria);
        for (Map.Entry<String, List<Launch>> entry : grouped.entrySet()) {
            List<Launch> launches = entry.getValue();
            Integer count = null != launches ? launches.size() : 0;
            ChartObject group = new ChartObject();
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("count", String.valueOf(count));
            values.put("interval", interval.getInterval());
            if (criteria != ProjectInfoGroup.BY_DAY) {
                long numberOfWeek = formatter.parse(entry.getKey()).getLong(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
                LocalDate startPeriod = ProjectInfoWidgetDataConverter.parseByDayOfWeek(entry, numberOfWeek, DayOfWeek.MONDAY);
                values.put("start", startPeriod.format(DateTimeFormatter.ISO_DATE));
                LocalDate endPeriod = ProjectInfoWidgetDataConverter.parseByDayOfWeek(entry, numberOfWeek, DayOfWeek.SUNDAY);
                values.put("end", endPeriod.format(DateTimeFormatter.ISO_DATE));
            } else {
                values.put("start", entry.getKey());
            }
            group.setName("Number of launches");
            group.setValues(values);
            result.put(entry.getKey(), Collections.singletonList(group));
        }
        return result;
    }

    public Map<String, List<ChartObject>> getLaunchesIssues(List<Launch> initial, InfoInterval interval) {
        HashMap<String, List<ChartObject>> result = new HashMap<String, List<ChartObject>>();
        if (initial.isEmpty()) {
            return result;
        }
        String PB = "productBug";
        String SI = "systemIssue";
        String AB = "automationBug";
        String TI = "toInvestigate";
        ProjectInfoGroup criteria = this.grouping.get(interval);
        Map<String, List<Launch>> grouped = ProjectInfoWidgetDataConverter.groupBy(initial, criteria);
        for (Map.Entry<String, List<Launch>> entry : grouped.entrySet()) {
            List<Launch> launches = entry.getValue();
            Integer pbCount = 0;
            Integer abCount = 0;
            Integer siCount = 0;
            Integer tiCount = 0;
            for (Launch launch : launches) {
                pbCount = pbCount + StatisticsHelper.extractStatisticsCount("statistics$defects$product_bug$total", launch.getStatistics());
                abCount = abCount + StatisticsHelper.extractStatisticsCount("statistics$defects$automation_bug$total", launch.getStatistics());
                siCount = siCount + StatisticsHelper.extractStatisticsCount("statistics$defects$system_issue$total", launch.getStatistics());
                tiCount = tiCount + StatisticsHelper.extractStatisticsCount("statistics$defects$to_investigate$total", launch.getStatistics());
            }
            ChartObject object = new ChartObject();
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("productBug", String.valueOf(pbCount));
            values.put("systemIssue", String.valueOf(siCount));
            values.put("automationBug", String.valueOf(abCount));
            values.put("toInvestigate", String.valueOf(tiCount));
            object.setValues(values);
            result.put(entry.getKey(), Collections.singletonList(object));
        }
        return result;
    }

    private static Map<String, List<Launch>> groupBy(List<Launch> initial, ProjectInfoGroup criteria) {
        LinkedHashMap<String, List<Launch>> result = new LinkedHashMap<String, List<Launch>>();
        LocalDate prevDate = null;
        for (Launch launch : initial) {
            String key;
            LocalDate localDate = launch.getStartTime().atZone(ZoneOffset.UTC).toLocalDate();
            switch (criteria.ordinal()) {
                case 2: {
                    key = launch.getName();
                    break;
                }
                default: {
                    key = ProjectInfoWidgetDataConverter.formattedDate(criteria, localDate);
                    if (prevDate == null) break;
                    while (prevDate.isBefore(localDate)) {
                        if (!result.containsKey(ProjectInfoWidgetDataConverter.formattedDate(criteria, prevDate))) {
                            result.put(ProjectInfoWidgetDataConverter.formattedDate(criteria, prevDate), new ArrayList());
                        }
                        prevDate = prevDate.plus(1L, criteria == ProjectInfoGroup.BY_DAY ? ChronoUnit.DAYS : ChronoUnit.WEEKS);
                    }
                    break block0;
                }
            }
            if (!result.containsKey(key)) {
                result.put(key, Lists.newArrayList((Object[])new Launch[]{launch}));
            } else {
                List prev = (List)result.get(key);
                prev.add(launch);
                result.put(key, prev);
            }
            prevDate = localDate;
        }
        return result;
    }

    private static String formattedDate(ProjectInfoGroup criteria, LocalDate localDate) {
        return criteria == ProjectInfoGroup.BY_DAY ? localDate.toString() : formatter.format(localDate);
    }

    private static LocalDate parseByDayOfWeek(Map.Entry<String, List<Launch>> entry, long numberOfWeek, DayOfWeek dayOfWeek) {
        int year = (int)formatter.parse(entry.getKey()).getLong(IsoFields.WEEK_BASED_YEAR);
        return LocalDate.of(year, 1, 1).with(TemporalAdjusters.firstInMonth(dayOfWeek)).with(WeekFields.ISO.weekOfWeekBasedYear(), numberOfWeek);
    }

    public static enum ProjectInfoGroup {
        BY_DAY,
        BY_WEEK,
        BY_NAME;

    }
}

