/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CompositeFilterCondition;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.jasper.GetJasperReportHandler;
import com.epam.ta.reportportal.core.project.GetProjectHandler;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.jasper.ReportFormat;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectInfo;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.model.project.ProjectResource;
import com.epam.ta.reportportal.model.user.SearchUserResource;
import com.epam.ta.reportportal.model.user.UserResource;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.ProjectConverter;
import com.epam.ta.reportportal.ws.converter.converters.UserConverter;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GetProjectHandlerImpl
implements GetProjectHandler {
    private static final String LENGTH_LESS_THAN_1_SYMBOL_MSG = "Length of the filtering string '{}' is less than 1 symbol";
    private final ProjectRepository projectRepository;
    private final UserRepository userRepository;
    private final GetJasperReportHandler<ProjectInfo> jasperReportHandler;
    private final ProjectConverter projectConverter;
    @Value(value="${rp.environment.variable.user.suggestions:true}")
    boolean isUserSuggestions;

    @Autowired
    public GetProjectHandlerImpl(ProjectRepository projectRepository, UserRepository userRepository, @Qualifier(value="projectJasperReportHandler") GetJasperReportHandler<ProjectInfo> jasperReportHandler, ProjectConverter projectConverter) {
        this.projectRepository = projectRepository;
        this.userRepository = userRepository;
        this.jasperReportHandler = jasperReportHandler;
        this.projectConverter = projectConverter;
    }

    @Override
    public com.epam.ta.reportportal.model.Page<UserResource> getProjectUsers(String projectName, Filter filter, Pageable pageable) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        if (CollectionUtils.isEmpty((Collection)project.getUsers())) {
            return PagedResourcesAssembler.pageConverter(UserConverter.TO_RESOURCE).apply((Page<User>)Page.empty((Pageable)pageable));
        }
        filter.withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, String.valueOf(project.getId()), "projectId"));
        Page users = this.userRepository.findByFilterExcluding((Queryable)filter, pageable, new String[]{"email"});
        return PagedResourcesAssembler.pageConverter(UserConverter.TO_RESOURCE).apply((Page<User>)users);
    }

    @Override
    public boolean exists(Long id) {
        return this.projectRepository.existsById((Object)id);
    }

    @Override
    public Project get(ReportPortalUser.ProjectDetails projectDetails) {
        return (Project)this.projectRepository.findById((Object)projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectName()}));
    }

    @Override
    public Project get(Long id) {
        return (Project)this.projectRepository.findById((Object)id).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{id}));
    }

    @Override
    public Project get(String name) {
        return (Project)this.projectRepository.findByName(name).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{name}));
    }

    @Override
    public Project getRaw(String name) {
        return (Project)this.projectRepository.findRawByName(name).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{name}));
    }

    @Override
    public ProjectResource getResource(String projectName, ReportPortalUser user) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        return this.projectConverter.TO_PROJECT_RESOURCE.apply(project);
    }

    @Override
    public List<String> getUserNames(ReportPortalUser.ProjectDetails projectDetails, String value) {
        this.checkBusinessRuleLessThan1Symbol(value);
        return this.userRepository.findNamesByProject(projectDetails.getProjectId(), value);
    }

    private void checkBusinessRuleLessThan1Symbol(String value) {
        BusinessRule.expect((Object)(value.length() >= 1 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)LENGTH_LESS_THAN_1_SYMBOL_MSG, (Object[])new Object[]{value})});
    }

    @Override
    public com.epam.ta.reportportal.model.Page<SearchUserResource> getUserNames(String value, UserRole userRole, ReportPortalUser.ProjectDetails projectDetails, Pageable pageable) {
        this.checkBusinessRuleLessThan1Symbol(value);
        CompositeFilterCondition userCondition = userRole.equals((Object)UserRole.ADMINISTRATOR) || this.isUserSuggestions ? this.getUserSearchSuggestCondition(value) : this.getUserSearchCondition(value);
        Filter filter = Filter.builder().withTarget(User.class).withCondition((ConvertibleCondition)userCondition).withCondition((ConvertibleCondition)new FilterCondition(Operator.AND, Condition.ANY, true, projectDetails.getProjectName(), "project")).build();
        return PagedResourcesAssembler.pageConverter(UserConverter.TO_SEARCH_RESOURCE).apply((Page<User>)this.userRepository.findByFilterExcludingProjects((Queryable)filter, pageable));
    }

    private CompositeFilterCondition getUserSearchSuggestCondition(String value) {
        return new CompositeFilterCondition(List.of(new FilterCondition(Operator.OR, Condition.CONTAINS, false, value, "user"), new FilterCondition(Operator.OR, Condition.CONTAINS, false, value, "fullName"), new FilterCondition(Operator.OR, Condition.CONTAINS, false, value, "email")), Operator.AND);
    }

    private CompositeFilterCondition getUserSearchCondition(String value) {
        return new CompositeFilterCondition(List.of(new FilterCondition(Operator.OR, Condition.EQUALS, false, value, "email")), Operator.AND);
    }

    @Override
    public List<String> getAllProjectNames() {
        return this.projectRepository.findAllProjectNames();
    }

    @Override
    public List<String> getAllProjectNamesByTerm(String term) {
        return this.projectRepository.findAllProjectNamesByTerm(term);
    }

    @Override
    public void exportProjects(ReportFormat reportFormat, Queryable filter, OutputStream outputStream) {
        List projects = this.projectRepository.findProjectInfoByFilter(filter);
        List data = projects.stream().map(this.jasperReportHandler::convertParams).collect(Collectors.toList());
        JRBeanCollectionDataSource jrDataSource = new JRBeanCollectionDataSource(data);
        JasperPrint jasperPrint = this.jasperReportHandler.getJasperPrint(null, (JRDataSource)jrDataSource);
        this.jasperReportHandler.writeReport(reportFormat, outputStream, jasperPrint);
    }

    @Override
    public Map<String, Boolean> getAnalyzerIndexingStatus() {
        return this.projectRepository.findAll().stream().collect(Collectors.toMap(Project::getName, it -> AnalyzerUtils.getAnalyzerConfig(it).isIndexingRunning()));
    }
}

