/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.binary.AttachmentBinaryDataService;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.ProjectBulkDeletedEvent;
import com.epam.ta.reportportal.core.events.activity.ProjectDeletedEvent;
import com.epam.ta.reportportal.core.events.activity.ProjectIndexEvent;
import com.epam.ta.reportportal.core.project.DeleteProjectHandler;
import com.epam.ta.reportportal.core.remover.ContentRemover;
import com.epam.ta.reportportal.dao.IssueTypeRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectIssueType;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.model.DeleteBulkRS;
import com.epam.ta.reportportal.util.FeatureFlagHandler;
import com.epam.ta.reportportal.ws.converter.converters.ExceptionConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DeleteProjectHandlerImpl
implements DeleteProjectHandler {
    private final ProjectRepository projectRepository;
    private final UserRepository userRepository;
    private final LogIndexer logIndexer;
    private final AnalyzerServiceClient analyzerServiceClient;
    private final AnalyzerStatusCache analyzerStatusCache;
    private final MessageBus messageBus;
    private final IssueTypeRepository issueTypeRepository;
    private final ContentRemover<Project> projectContentRemover;
    private final LogRepository logRepository;
    private final AttachmentBinaryDataService attachmentBinaryDataService;
    private final FeatureFlagHandler featureFlagHandler;

    @Autowired
    public DeleteProjectHandlerImpl(ProjectRepository projectRepository, UserRepository userRepository, LogIndexer logIndexer, AnalyzerServiceClient analyzerServiceClient, AnalyzerStatusCache analyzerStatusCache, MessageBus messageBus, AttachmentBinaryDataService attachmentBinaryDataService, IssueTypeRepository issueTypeRepository, ContentRemover<Project> projectContentRemover, LogRepository logRepository, FeatureFlagHandler featureFlagHandler) {
        this.projectRepository = projectRepository;
        this.userRepository = userRepository;
        this.logIndexer = logIndexer;
        this.analyzerServiceClient = analyzerServiceClient;
        this.analyzerStatusCache = analyzerStatusCache;
        this.messageBus = messageBus;
        this.issueTypeRepository = issueTypeRepository;
        this.projectContentRemover = projectContentRemover;
        this.logRepository = logRepository;
        this.featureFlagHandler = featureFlagHandler;
        this.attachmentBinaryDataService = attachmentBinaryDataService;
    }

    @Override
    public OperationCompletionRS deleteProject(Long projectId, ReportPortalUser user) {
        Project project = this.getProjectById(projectId);
        OperationCompletionRS operationCompletionRs = this.deleteProject(project);
        this.publishSpecialProjectDeletedEvent(user, project);
        return operationCompletionRs;
    }

    private void publishSpecialProjectDeletedEvent(ReportPortalUser user, Project project) {
        if (Objects.nonNull(user)) {
            Long userId = user.getUserId();
            String username = user.getUsername();
            this.publishProjectDeletedEvent(userId, username, project.getId(), project.getName());
        } else {
            this.publishProjectDeletedEvent(null, "ReportPortal", project.getId(), "personal_project");
        }
    }

    private void publishProjectDeletedEvent(Long userId, String userLogin, Long projectId, String projectName) {
        this.messageBus.publishActivity(new ProjectDeletedEvent(userId, userLogin, projectId, projectName));
    }

    private Project getProjectById(Long projectId) {
        return (Project)this.projectRepository.findById((Object)projectId).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectId}));
    }

    @Override
    public DeleteBulkRS bulkDeleteProjects(List<Long> ids, ReportPortalUser user) {
        ArrayList exceptions = Lists.newArrayList();
        HashMap deletedProjectsMap = Maps.newHashMap();
        ids.forEach(projectId -> {
            try {
                Project project = this.getProjectById((Long)projectId);
                this.deleteProject(project);
                deletedProjectsMap.put(projectId, project.getName());
            }
            catch (ReportPortalException ex) {
                exceptions.add(ex);
            }
        });
        this.publishProjectBulkDeletedEvent(user, deletedProjectsMap.values());
        return new DeleteBulkRS(List.copyOf(deletedProjectsMap.keySet()), Collections.emptyList(), exceptions.stream().map(ExceptionConverter.TO_ERROR_RS).collect(Collectors.toList()));
    }

    private void publishProjectBulkDeletedEvent(ReportPortalUser user, Collection<String> names) {
        ProjectBulkDeletedEvent bulkDeletedEvent = new ProjectBulkDeletedEvent(user.getUserId(), user.getUsername(), names);
        this.messageBus.publishActivity(bulkDeletedEvent);
    }

    @Override
    public OperationCompletionRS deleteProjectIndex(String projectName, String username) {
        BusinessRule.expect((Object)this.analyzerServiceClient.hasClients(), Predicate.isEqual(true)).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"There are no analyzer deployed."});
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        User user = (User)this.userRepository.findByLogin(username).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{username}));
        BusinessRule.expect((Object)AnalyzerUtils.getAnalyzerConfig(project).isIndexingRunning(), Predicate.isEqual(false)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Index can not be removed until index generation proceeds."});
        Cache<Long, Long> analyzeStatus = this.analyzerStatusCache.getAnalyzeStatus("autoAnalyzer").orElseThrow(() -> new ReportPortalException(ErrorType.ANALYZER_NOT_FOUND, new Object[]{"autoAnalyzer"}));
        BusinessRule.expect((Object)analyzeStatus.asMap().containsValue(project.getId()), Predicate.isEqual(false)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Index can not be removed until index generation proceeds."});
        this.logIndexer.deleteIndex(project.getId());
        this.messageBus.publishActivity(new ProjectIndexEvent(user.getId(), user.getLogin(), project.getId(), project.getName(), false));
        return new OperationCompletionRS("Project index with name = '" + projectName + "' is successfully deleted.");
    }

    private OperationCompletionRS deleteProject(Project project) {
        Set defaultIssueTypeIds = this.issueTypeRepository.getDefaultIssueTypes().stream().map(IssueType::getId).collect(Collectors.toSet());
        Set issueTypesToRemove = project.getProjectIssueTypes().stream().map(ProjectIssueType::getIssueType).filter(issueType -> !defaultIssueTypeIds.contains(issueType.getId())).collect(Collectors.toSet());
        this.projectRepository.delete((Object)project);
        this.issueTypeRepository.deleteAll(issueTypesToRemove);
        this.logIndexer.deleteIndex(project.getId());
        this.analyzerServiceClient.removeSuggest(project.getId());
        this.logRepository.deleteByProjectId(project.getId());
        this.attachmentBinaryDataService.deleteAllByProjectId(project.getId());
        this.projectContentRemover.remove(project);
        return new OperationCompletionRS("Project with id = '" + project.getId() + "' has been successfully deleted.");
    }
}

