/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.log.impl;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.binary.AttachmentBinaryDataService;
import com.epam.ta.reportportal.commons.BinaryDataMetaInfo;
import com.epam.ta.reportportal.entity.attachment.AttachmentMetaInfo;
import com.epam.ta.reportportal.ws.reporting.SaveLogRQ;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public class SaveLogBinaryDataTaskAsync
implements Supplier<BinaryDataMetaInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveLogBinaryDataTaskAsync.class);
    @Autowired
    private AttachmentBinaryDataService attachmentBinaryDataService;
    private SaveLogRQ request;
    private MultipartFile file;
    private Long projectId;

    @Override
    public BinaryDataMetaInfo get() {
        Optional maybeBinaryDataMetaInfo = this.attachmentBinaryDataService.saveAttachment(AttachmentMetaInfo.builder().withProjectId(this.projectId).withLaunchUuid(this.request.getLaunchUuid()).withLogUuid(this.request.getUuid()).build(), this.file);
        return maybeBinaryDataMetaInfo.orElseGet(() -> {
            LOGGER.error("Failed to save log content data into DataStore, projectId {}, itemId {} ", (Object)this.projectId, (Object)this.request.getItemUuid());
            throw new ReportPortalException(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, new Object[0]);
        });
    }

    public SaveLogBinaryDataTaskAsync withRequest(SaveLogRQ request) {
        Preconditions.checkNotNull((Object)request, (Object)"Request shouldn't be null");
        this.request = request;
        return this;
    }

    public SaveLogBinaryDataTaskAsync withFile(MultipartFile file) {
        this.file = file;
        return this;
    }

    public SaveLogBinaryDataTaskAsync withProjectId(Long projectId) {
        Preconditions.checkNotNull((Object)projectId, (Object)"Project id should not be null");
        this.projectId = projectId;
        return this;
    }
}

