/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.util;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.web.util.ForwardedHeaderUtils;

@Component
public final class LinkGenerator {
    private static final String UI_PREFIX = "/ui/#";
    private static final String LAUNCHES = "/launches/all/";
    private static String path;
    @Value(value="${server.servlet.context-path:/api}")
    private String pathValue;

    @PostConstruct
    public void init() {
        path = this.pathValue;
    }

    private LinkGenerator() {
    }

    public static String generateLaunchLink(String baseUrl, String projectName, String id) {
        return StringUtils.isEmpty((CharSequence)baseUrl) ? null : baseUrl + UI_PREFIX + projectName + LAUNCHES + id;
    }

    public static String composeBaseUrl(HttpServletRequest request) {
        String[] forwardedHeaders;
        String processedPath = "/".equals(path) ? null : path.replace("/api", "");
        HttpHeaders httpHeaders = new HttpHeaders();
        for (String headerName : forwardedHeaders = new String[]{"x-forwarded-host", "x-forwarded-proto", "x-forwarded-port", "x-forwarded-for", "forwarded"}) {
            String headerValue = request.getHeader(headerName);
            if (headerValue == null) continue;
            httpHeaders.add(headerName, headerValue);
        }
        URI uri = new URI(request.getRequestURI());
        return ForwardedHeaderUtils.adaptFromForwardedHeaders((URI)uri, (HttpHeaders)httpHeaders).replacePath(processedPath).replaceQuery(null).build().toUri().toASCIIString();
    }
}

