/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.reportportal.events.ElementsDeletedEvent;
import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorRS;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.ElementsCounterService;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.LaunchDeletedEvent;
import com.epam.ta.reportportal.core.launch.DeleteLaunchHandler;
import com.epam.ta.reportportal.core.log.LogService;
import com.epam.ta.reportportal.core.remover.ContentRemover;
import com.epam.ta.reportportal.dao.AttachmentRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.model.DeleteBulkRS;
import com.epam.ta.reportportal.model.activity.LaunchActivityResource;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.google.api.client.util.Maps;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class DeleteLaunchHandlerImpl
implements DeleteLaunchHandler {
    private final ContentRemover<Launch> launchContentRemover;
    private final LaunchRepository launchRepository;
    private final MessageBus messageBus;
    private final LogIndexer logIndexer;
    private final AttachmentRepository attachmentRepository;
    private final ApplicationEventPublisher eventPublisher;
    private final ElementsCounterService elementsCounterService;
    private final LogService logService;

    @Autowired
    public DeleteLaunchHandlerImpl(ContentRemover<Launch> launchContentRemover, LaunchRepository launchRepository, MessageBus messageBus, LogIndexer logIndexer, AttachmentRepository attachmentRepository, ApplicationEventPublisher eventPublisher, ElementsCounterService elementsCounterService, LogService logService) {
        this.launchContentRemover = launchContentRemover;
        this.launchRepository = launchRepository;
        this.messageBus = messageBus;
        this.logIndexer = logIndexer;
        this.attachmentRepository = attachmentRepository;
        this.eventPublisher = eventPublisher;
        this.elementsCounterService = elementsCounterService;
        this.logService = logService;
    }

    @Override
    public OperationCompletionRS deleteLaunch(Long launchId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Launch launch = (Launch)this.launchRepository.findById((Object)launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
        this.validate(launch, user, projectDetails);
        Long numberOfLaunchElements = this.elementsCounterService.countNumberOfLaunchElements(launchId);
        this.logIndexer.indexLaunchesRemove(projectDetails.getProjectId(), Lists.newArrayList((Object[])new Long[]{launchId}));
        this.launchContentRemover.remove(launch);
        this.logService.deleteLogMessageByLaunch(projectDetails.getProjectId(), launch.getId());
        this.launchRepository.delete((Object)launch);
        this.attachmentRepository.moveForDeletionByLaunchId(launchId);
        this.messageBus.publishActivity(new LaunchDeletedEvent(LaunchConverter.TO_ACTIVITY_RESOURCE.apply(launch), user.getUserId(), user.getUsername()));
        this.eventPublisher.publishEvent((ApplicationEvent)new ElementsDeletedEvent((Object)launchId, launch.getProjectId(), numberOfLaunchElements.longValue()));
        return new OperationCompletionRS("Launch with ID = '" + launchId + "' successfully deleted.");
    }

    @Override
    public DeleteBulkRS deleteLaunches(List<Long> ids, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        ArrayList notFound = Lists.newArrayList();
        ArrayList exceptions = Lists.newArrayList();
        HashMap toDelete = Maps.newHashMap();
        ArrayList launchIds = Lists.newArrayList();
        ids.forEach(id -> {
            Optional optionalLaunch = this.launchRepository.findById(id);
            if (optionalLaunch.isPresent()) {
                Launch launch = (Launch)optionalLaunch.get();
                try {
                    this.validate(launch, user, projectDetails);
                    Long numberOfLaunchElements = this.elementsCounterService.countNumberOfLaunchElements(launch.getId());
                    toDelete.put(launch, numberOfLaunchElements);
                    launchIds.add(id);
                }
                catch (ReportPortalException ex) {
                    exceptions.add(ex);
                }
            } else {
                notFound.add(id);
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)launchIds)) {
            this.logIndexer.indexLaunchesRemove(projectDetails.getProjectId(), launchIds);
            toDelete.keySet().forEach(this.launchContentRemover::remove);
            this.logService.deleteLogMessageByLaunchList(projectDetails.getProjectId(), launchIds);
            this.launchRepository.deleteAll(toDelete.keySet());
            this.attachmentRepository.moveForDeletionByLaunchIds((Collection)launchIds);
        }
        toDelete.entrySet().forEach(entry -> {
            LaunchActivityResource launchActivity = LaunchConverter.TO_ACTIVITY_RESOURCE.apply((Launch)entry.getKey());
            this.messageBus.publishActivity(new LaunchDeletedEvent(launchActivity, user.getUserId(), user.getUsername()));
            this.eventPublisher.publishEvent((ApplicationEvent)new ElementsDeletedEvent((Object)((Launch)entry.getKey()).getId(), ((Launch)entry.getKey()).getProjectId(), ((Long)entry.getValue()).longValue()));
        });
        return new DeleteBulkRS(launchIds, notFound, exceptions.stream().map(ex -> {
            ErrorRS errorResponse = new ErrorRS();
            errorResponse.setErrorType(ex.getErrorType());
            errorResponse.setMessage(ex.getMessage());
            return errorResponse;
        }).collect(Collectors.toList()));
    }

    private void validate(Launch launch, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        BusinessRule.expect((Object)launch, (Predicate)Predicates.not(l -> StatusEnum.IN_PROGRESS.equals((Object)l.getStatus()))).verify(ErrorType.LAUNCH_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete launch '{}' in progress state", (Object[])new Object[]{launch.getId()})});
        if (!UserRole.ADMINISTRATOR.equals((Object)user.getUserRole())) {
            BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Target launch '{}' not under specified project '{}'", (Object[])new Object[]{launch.getId(), projectDetails.getProjectId()})});
            if (projectDetails.getProjectRole().lowerThan(ProjectRole.PROJECT_MANAGER)) {
                BusinessRule.expect((Object)user.getUserId(), Predicate.isEqual(launch.getUserId())).verify(ErrorType.ACCESS_DENIED, new Object[]{"You are not launch owner."});
            }
        }
    }
}

