/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.cluster.pipeline.data;

import com.epam.reportportal.model.analyzer.IndexLaunch;
import com.epam.ta.reportportal.core.analyzer.auto.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.impl.preparer.LaunchPreparerService;
import com.epam.ta.reportportal.core.launch.GetLaunchHandler;
import com.epam.ta.reportportal.core.launch.cluster.config.ClusterEntityContext;
import com.epam.ta.reportportal.core.launch.cluster.config.GenerateClustersConfig;
import com.epam.ta.reportportal.core.launch.cluster.pipeline.data.AnalyzerClusterDataProvider;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.launch.Launch;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;

public class AnalyzerItemClusterDataProvider
extends AnalyzerClusterDataProvider {
    private final GetLaunchHandler getLaunchHandler;
    private final TestItemRepository testItemRepository;
    private final LaunchPreparerService launchPreparerService;

    public AnalyzerItemClusterDataProvider(AnalyzerServiceClient analyzerServiceClient, GetLaunchHandler getLaunchHandler, TestItemRepository testItemRepository, LaunchPreparerService launchPreparerService) {
        super(analyzerServiceClient);
        this.getLaunchHandler = getLaunchHandler;
        this.testItemRepository = testItemRepository;
        this.launchPreparerService = launchPreparerService;
    }

    @Override
    protected Optional<IndexLaunch> prepareIndexLaunch(GenerateClustersConfig config) {
        ClusterEntityContext entityContext = config.getEntityContext();
        if (CollectionUtils.isEmpty(entityContext.getItemIds())) {
            return Optional.empty();
        }
        Launch launch = this.getLaunchHandler.get(entityContext.getLaunchId());
        List testItems = this.testItemRepository.findAllById(entityContext.getItemIds());
        return this.launchPreparerService.prepare(launch, testItems, config.getAnalyzerConfig());
    }
}

