/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.cluster;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.core.launch.cluster.ClusterGenerator;
import com.epam.ta.reportportal.core.launch.cluster.UniqueErrorGeneratorAsync;
import com.epam.ta.reportportal.core.launch.cluster.config.ClusterEntityContext;
import com.epam.ta.reportportal.core.launch.cluster.config.GenerateClustersConfig;
import com.epam.ta.reportportal.pipeline.PipelineConstructor;
import com.epam.ta.reportportal.pipeline.PipelinePart;
import com.epam.ta.reportportal.pipeline.TransactionalPipeline;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UniqueErrorGenerator
implements ClusterGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniqueErrorGeneratorAsync.class);
    private final AnalyzerStatusCache analyzerStatusCache;
    private final PipelineConstructor<GenerateClustersConfig> generateClustersPipelineConstructor;
    private final TransactionalPipeline transactionalPipeline;

    @Autowired
    public UniqueErrorGenerator(AnalyzerStatusCache analyzerStatusCache, PipelineConstructor<GenerateClustersConfig> generateClustersPipelineConstructor, TransactionalPipeline transactionalPipeline) {
        this.analyzerStatusCache = analyzerStatusCache;
        this.generateClustersPipelineConstructor = generateClustersPipelineConstructor;
        this.transactionalPipeline = transactionalPipeline;
    }

    @Override
    public void generate(GenerateClustersConfig config) {
        this.fillCache(config.getEntityContext());
        this.generateClusters(config);
    }

    protected void fillCache(ClusterEntityContext entityContext) {
        this.checkDuplicate(entityContext);
        this.analyzerStatusCache.analyzeStarted("cluster", entityContext.getLaunchId(), entityContext.getProjectId());
    }

    private void checkDuplicate(ClusterEntityContext entityContext) {
        BusinessRule.expect((Object)this.analyzerStatusCache.containsLaunchId("cluster", entityContext.getLaunchId()), Predicate.isEqual(false)).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Clusters creation is in progress."});
    }

    protected void generateClusters(GenerateClustersConfig config) {
        try {
            List<PipelinePart> pipelineParts = this.generateClustersPipelineConstructor.construct(config);
            this.transactionalPipeline.run(pipelineParts);
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.cleanCache(config.getEntityContext());
        }
    }

    protected void cleanCache(ClusterEntityContext entityContext) {
        this.analyzerStatusCache.analyzeFinished("cluster", entityContext.getLaunchId());
    }
}

