/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.cluster;

import com.epam.reportportal.extension.event.GetClusterResourcesEvent;
import com.epam.reportportal.model.launch.cluster.ClusterInfoResource;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.launch.cluster.GetClusterHandler;
import com.epam.ta.reportportal.dao.ClusterRepository;
import com.epam.ta.reportportal.entity.cluster.Cluster;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class GetClusterHandlerImpl
implements GetClusterHandler {
    private final ClusterRepository clusterRepository;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public GetClusterHandlerImpl(ClusterRepository clusterRepository, ApplicationEventPublisher eventPublisher) {
        this.clusterRepository = clusterRepository;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public Cluster getById(Long id) {
        return (Cluster)this.clusterRepository.findById((Object)id).orElseThrow(() -> new ReportPortalException(ErrorType.CLUSTER_NOT_FOUND, new Object[]{id}));
    }

    @Override
    public com.epam.ta.reportportal.model.Page<ClusterInfoResource> getResources(Launch launch, Pageable pageable) {
        Page clusters = this.clusterRepository.findAllByLaunchIdWithCount(launch.getId(), pageable);
        return this.getClusterResources((Page<ClusterInfoResource>)clusters, launch.getId());
    }

    private com.epam.ta.reportportal.model.Page<ClusterInfoResource> getClusterResources(Page<ClusterInfoResource> clusters, Long launchId) {
        com.epam.ta.reportportal.model.Page<ClusterInfoResource> clustersPage = PagedResourcesAssembler.pageConverter(c -> c).apply(clusters);
        this.eventPublisher.publishEvent((ApplicationEvent)new GetClusterResourcesEvent(clustersPage.getContent(), launchId));
        return clustersPage;
    }
}

