/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.attribute.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.MarkLaunchAsImportantEvent;
import com.epam.ta.reportportal.core.events.activity.UnmarkLaunchAsImportantEvent;
import com.epam.ta.reportportal.core.launch.attribute.AttributeHandler;
import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.enums.RetentionPolicyEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RetentionPolicyAttributeHandler
implements AttributeHandler {
    private final MessageBus messageBus;

    @Autowired
    public RetentionPolicyAttributeHandler(MessageBus messageBus) {
        this.messageBus = messageBus;
    }

    @Override
    public void handleLaunchStart(Launch launch) {
        if (launch == null || launch.getAttributes() == null) {
            return;
        }
        Set attributes = launch.getAttributes();
        ItemAttribute importantAttribute = null;
        ItemAttribute regularAttribute = null;
        for (ItemAttribute attribute : attributes) {
            if (!attribute.isSystem().booleanValue() || !"retentionPolicy".equals(attribute.getKey())) continue;
            if ("important".equalsIgnoreCase(attribute.getValue())) {
                importantAttribute = attribute;
                continue;
            }
            if (!"regular".equalsIgnoreCase(attribute.getValue())) continue;
            regularAttribute = attribute;
        }
        if (importantAttribute != null && regularAttribute != null) {
            attributes.remove(regularAttribute);
            launch.setRetentionPolicy(RetentionPolicyEnum.IMPORTANT);
        } else if (importantAttribute != null) {
            launch.setRetentionPolicy(RetentionPolicyEnum.IMPORTANT);
        } else {
            launch.setRetentionPolicy(RetentionPolicyEnum.REGULAR);
        }
    }

    @Override
    public void handleLaunchUpdate(Launch launch, ReportPortalUser user) {
        if (launch == null || launch.getAttributes() == null) {
            return;
        }
        Set itemAttributes = launch.getAttributes();
        ItemAttribute retentionPolicyOldAttribute = null;
        ItemAttribute retentionPolicyNewAttribute = null;
        for (ItemAttribute attribute : itemAttributes) {
            if (!"retentionPolicy".equalsIgnoreCase(attribute.getKey())) continue;
            if (attribute.isSystem().booleanValue()) {
                retentionPolicyOldAttribute = attribute;
                continue;
            }
            retentionPolicyNewAttribute = attribute;
        }
        if (retentionPolicyNewAttribute != null) {
            itemAttributes.remove(retentionPolicyOldAttribute);
            retentionPolicyNewAttribute.setSystem(Boolean.valueOf(true));
            if (retentionPolicyOldAttribute != null && Objects.equals(retentionPolicyOldAttribute.getValue(), retentionPolicyNewAttribute.getValue())) {
                return;
            }
            if ("important".equalsIgnoreCase(retentionPolicyNewAttribute.getValue())) {
                launch.setRetentionPolicy(RetentionPolicyEnum.IMPORTANT);
                this.messageBus.publishActivity(new MarkLaunchAsImportantEvent(LaunchConverter.TO_ACTIVITY_RESOURCE.apply(launch), user.getUserId(), user.getUsername()));
            } else if ("regular".equalsIgnoreCase(retentionPolicyNewAttribute.getValue())) {
                launch.setRetentionPolicy(RetentionPolicyEnum.REGULAR);
                this.messageBus.publishActivity(new UnmarkLaunchAsImportantEvent(LaunchConverter.TO_ACTIVITY_RESOURCE.apply(launch), user.getUserId(), user.getUsername()));
            }
        }
    }
}

