/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.status;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.item.TestItemService;
import com.epam.ta.reportportal.core.item.impl.IssueTypeHandler;
import com.epam.ta.reportportal.core.item.impl.status.AbstractStatusChangingStrategy;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ToFailedStatusChangingStrategy
extends AbstractStatusChangingStrategy {
    @Autowired
    public ToFailedStatusChangingStrategy(TestItemService testItemService, ProjectRepository projectRepository, LaunchRepository launchRepository, TestItemRepository testItemRepository, IssueTypeHandler issueTypeHandler, MessageBus messageBus, IssueEntityRepository issueEntityRepository, LogRepository logRepository, LogIndexer logIndexer) {
        super(testItemService, projectRepository, launchRepository, testItemRepository, issueTypeHandler, messageBus, issueEntityRepository, logRepository, logIndexer);
    }

    @Override
    protected void updateStatus(Project project, Launch launch, TestItem testItem, StatusEnum providedStatus, ReportPortalUser user, boolean updateParents) {
        BusinessRule.expect((Object)providedStatus, (Predicate)Preconditions.statusIn((StatusEnum[])new StatusEnum[]{StatusEnum.FAILED})).verify(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Incorrect status - '{}', only '{}' is allowed", (Object[])new Object[]{providedStatus, StatusEnum.FAILED}).get()});
        testItem.getItemResults().setStatus(providedStatus);
        if (Objects.isNull(testItem.getRetryOf())) {
            if (testItem.getItemResults().getIssue() == null && testItem.isHasStats()) {
                this.addToInvestigateIssue(testItem, project.getId());
            }
            ArrayList<Long> itemsToReindex = new ArrayList<Long>();
            if (updateParents) {
                itemsToReindex = this.changeParentsStatuses(testItem, launch, true, user);
            }
            itemsToReindex.add(testItem.getItemId());
            this.logIndexer.indexItemsRemove(project.getId(), itemsToReindex);
            this.logIndexer.indexItemsLogs(project.getId(), launch.getId(), itemsToReindex, AnalyzerUtils.getAnalyzerConfig(project));
        }
    }

    @Override
    protected StatusEnum evaluateParentItemStatus(TestItem parentItem, TestItem childItem) {
        return StatusEnum.FAILED;
    }
}

