/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.provider.impl;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CompositeFilter;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.item.impl.LaunchAccessValidator;
import com.epam.ta.reportportal.core.item.impl.filter.updater.FilterUpdater;
import com.epam.ta.reportportal.core.item.impl.provider.DataProviderHandler;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.statistics.Statistics;
import com.epam.ta.reportportal.util.ControllerUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class BaselineLaunchDataProvider
implements DataProviderHandler {
    private static final String LAUNCH_ID_PARAM = "launchId";
    private static final String BASELINE_LAUNCH_ID_PARAM = "baselineLaunchId";
    private final LaunchAccessValidator launchAccessValidator;
    private final TestItemRepository testItemRepository;
    private final FilterUpdater filterUpdater;

    @Autowired
    public BaselineLaunchDataProvider(LaunchAccessValidator launchAccessValidator, TestItemRepository testItemRepository, FilterUpdater filterUpdater) {
        this.launchAccessValidator = launchAccessValidator;
        this.testItemRepository = testItemRepository;
        this.filterUpdater = filterUpdater;
    }

    @Override
    public Page<TestItem> getTestItems(Queryable filter, Pageable pageable, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, Map<String, String> params) {
        Queryable targetFilter = this.getLaunchIdFilter(LAUNCH_ID_PARAM, params, projectDetails, user);
        Queryable baselineFilter = this.getLaunchIdFilter(BASELINE_LAUNCH_ID_PARAM, params, projectDetails, user);
        this.filterUpdater.update(filter);
        return this.testItemRepository.findAllNotFromBaseline(this.joinFilters(targetFilter, filter), this.joinFilters(baselineFilter, filter), pageable);
    }

    @Override
    public Set<Statistics> accumulateStatistics(Queryable filter, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, Map<String, String> params) {
        Queryable targetFilter = this.getLaunchIdFilter(LAUNCH_ID_PARAM, params, projectDetails, user);
        Queryable baselineFilter = this.getLaunchIdFilter(BASELINE_LAUNCH_ID_PARAM, params, projectDetails, user);
        this.filterUpdater.update(filter);
        return this.testItemRepository.accumulateStatisticsByFilterNotFromBaseline(this.joinFilters(targetFilter, filter), this.joinFilters(baselineFilter, filter));
    }

    private Queryable getLaunchIdFilter(String key, Map<String, String> params, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Long launchId = this.getLaunchId(key, params);
        this.launchAccessValidator.validate(launchId, projectDetails, user);
        return this.getLaunchIdFilter(launchId);
    }

    private Long getLaunchId(String key, Map<String, String> params) {
        return Optional.ofNullable(params.get(key)).map(ControllerUtils::safeParseLong).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Launch id must be provided for baseline items provider"}));
    }

    private Queryable getLaunchIdFilter(Long launchId) {
        return Filter.builder().withTarget(TestItem.class).withCondition((ConvertibleCondition)FilterCondition.builder().eq(LAUNCH_ID_PARAM, String.valueOf(launchId)).build()).build();
    }

    private Queryable joinFilters(Queryable ... filters) {
        return new CompositeFilter(Operator.AND, filters);
    }
}

