/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.history.provider.impl;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.item.impl.history.param.HistoryRequestParams;
import com.epam.ta.reportportal.core.item.impl.history.provider.HistoryProvider;
import com.epam.ta.reportportal.core.item.utils.DefaultLaunchFilterProvider;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.dao.UserFilterRepository;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.item.history.TestItemHistory;
import com.epam.ta.reportportal.entity.launch.Launch;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ComparingBaselineHistoryProvider
implements HistoryProvider {
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final UserFilterRepository userFilterRepository;

    public ComparingBaselineHistoryProvider(LaunchRepository launchRepository, TestItemRepository testItemRepository, UserFilterRepository userFilterRepository) {
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.userFilterRepository = userFilterRepository;
    }

    @Override
    public Page<TestItemHistory> provide(Queryable filter, Pageable pageable, HistoryRequestParams historyRequestParams, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, boolean usingHash) {
        return historyRequestParams.getFilterParams().map(filterParams -> {
            UserFilter userFilter = (UserFilter)this.userFilterRepository.findByIdAndProjectId(filterParams.getFilterId(), projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_FILTER_NOT_FOUND_IN_PROJECT, new Object[]{filterParams.getFilterId(), projectDetails.getProjectName()}));
            Pair<Queryable, Pageable> launchQueryablePair = DefaultLaunchFilterProvider.createDefaultLaunchQueryablePair(projectDetails, userFilter, filterParams.getLaunchesLimit());
            List launchIds = this.launchRepository.findAllLatestByFilter((Queryable)launchQueryablePair.getLeft(), (Pageable)launchQueryablePair.getRight()).getContent().stream().map(Launch::getId).collect(Collectors.toList());
            return this.testItemRepository.loadItemsHistoryPage(filter, pageable, projectDetails.getProjectId(), launchIds, historyRequestParams.getHistoryDepth(), usingHash);
        }).orElseGet(() -> Page.empty((Pageable)pageable));
    }
}

