/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.util.validator;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.entity.project.Project;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public final class IntegrationValidator {
    private IntegrationValidator() {
    }

    public static void validateProjectLevelIntegrationConstraints(Project project, Integration integration) {
        BusinessRule.expect((Object)integration.getProject(), Objects::isNull).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{Suppliers.formattedSupplier((String)"Integration with ID = '{}' is not global.", (Object[])new Object[]{integration.getId()})});
        BusinessRule.expect((Object)project.getIntegrations().stream().map(Integration::getType).noneMatch(it -> {
            IntegrationType integrationType = integration.getType();
            return it.getIntegrationGroup() == integrationType.getIntegrationGroup() && StringUtils.equalsIgnoreCase((CharSequence)it.getName(), (CharSequence)integrationType.getName());
        }), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{Suppliers.formattedSupplier((String)"Global integration with ID = '{}' has been found, but you cannot use it, because you have project-level integration(s) of that type", (Object[])new Object[]{integration.getId()}).get()});
    }
}

