/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.util;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.integration.util.BasicIntegrationServiceImpl;
import com.epam.ta.reportportal.core.integration.util.property.SauceLabsProperties;
import com.epam.ta.reportportal.core.plugin.PluginBox;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.jasypt.util.text.BasicTextEncryptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SauceLabsIntegrationService
extends BasicIntegrationServiceImpl {
    private final BasicTextEncryptor encryptor;

    @Autowired
    public SauceLabsIntegrationService(IntegrationRepository integrationRepository, PluginBox pluginBox, BasicTextEncryptor encryptor) {
        super(integrationRepository, pluginBox);
        this.encryptor = encryptor;
    }

    @Override
    public Map<String, Object> retrieveCreateParams(String integrationType, Map<String, Object> integrationParams) {
        BusinessRule.expect(integrationParams, MapUtils::isNotEmpty).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"No integration params provided"});
        String encryptedToken = this.encryptor.encrypt(SauceLabsProperties.ACCESS_TOKEN.getParameter(integrationParams).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Access token value is not specified"})));
        String username = SauceLabsProperties.USERNAME.getParameter(integrationParams).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Username value is not specified"}));
        HashMap result = Maps.newHashMapWithExpectedSize((int)integrationParams.size());
        result.put(SauceLabsProperties.ACCESS_TOKEN.getName(), encryptedToken);
        result.put(SauceLabsProperties.USERNAME.getName(), username);
        integrationParams.entrySet().stream().filter(it -> !((String)it.getKey()).equals(SauceLabsProperties.ACCESS_TOKEN.getName()) && !((String)it.getKey()).equals(SauceLabsProperties.USERNAME.getName())).forEach(it -> result.put((String)it.getKey(), it.getValue()));
        return result;
    }

    @Override
    public Map<String, Object> retrieveUpdatedParams(String integrationType, Map<String, Object> integrationParams) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)integrationParams.size());
        SauceLabsProperties.ACCESS_TOKEN.getParameter(integrationParams).ifPresent(token -> result.put(SauceLabsProperties.ACCESS_TOKEN.getName(), this.encryptor.encrypt(token)));
        SauceLabsProperties.USERNAME.getParameter(integrationParams).ifPresent(username -> result.put(SauceLabsProperties.USERNAME.getName(), username));
        integrationParams.entrySet().stream().filter(it -> !((String)it.getKey()).equals(SauceLabsProperties.ACCESS_TOKEN.getName()) && !((String)it.getKey()).equals(SauceLabsProperties.USERNAME.getName())).forEach(it -> result.put((String)it.getKey(), it.getValue()));
        return result;
    }
}

