/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.util;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.core.admin.ServerAdminHandlerImpl;
import com.epam.ta.reportportal.core.integration.util.BasicIntegrationServiceImpl;
import com.epam.ta.reportportal.core.plugin.PluginBox;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.entity.EmailSettingsEnum;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.model.integration.IntegrationRQ;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.google.common.collect.Maps;
import com.mchange.lang.IntegerUtils;
import jakarta.mail.MessagingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EmailServerIntegrationService
extends BasicIntegrationServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerAdminHandlerImpl.class);
    private final BasicTextEncryptor basicTextEncryptor;
    private final MailServiceFactory emailServiceFactory;

    public EmailServerIntegrationService(IntegrationRepository integrationRepository, PluginBox pluginBox, BasicTextEncryptor basicTextEncryptor, MailServiceFactory emailServiceFactory) {
        super(integrationRepository, pluginBox);
        this.basicTextEncryptor = basicTextEncryptor;
        this.emailServiceFactory = emailServiceFactory;
    }

    @Override
    public Map<String, Object> retrieveCreateParams(String integrationType, Map<String, Object> integrationParams) {
        BusinessRule.expect(integrationParams, MapUtils::isNotEmpty).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"No integration params provided"});
        HashMap resultParams = Maps.newHashMapWithExpectedSize((int)EmailSettingsEnum.values().length);
        Optional fromAttribute = EmailSettingsEnum.FROM.getAttribute(integrationParams);
        fromAttribute.ifPresent(from -> resultParams.put(EmailSettingsEnum.FROM.getAttribute(), from));
        Optional.ofNullable(integrationParams.get(EmailSettingsEnum.PORT.getAttribute())).ifPresent(p -> {
            int port = IntegerUtils.parseInt((String)String.valueOf(p), (int)-1);
            if (port <= 0 || port > 65535) {
                BusinessRule.fail().withError(ErrorType.INCORRECT_REQUEST, new Object[]{"Incorrect 'Port' value. Allowed value is [1..65535]"});
            }
            resultParams.put(EmailSettingsEnum.PORT.getAttribute(), p);
        });
        EmailSettingsEnum.PROTOCOL.getAttribute(integrationParams).ifPresent(protocol -> resultParams.put(EmailSettingsEnum.PROTOCOL.getAttribute(), protocol));
        EmailSettingsEnum.USERNAME.getAttribute(integrationParams).ifPresent(username -> resultParams.put(EmailSettingsEnum.USERNAME.getAttribute(), username));
        Optional.ofNullable(integrationParams.get(EmailSettingsEnum.AUTH_ENABLED.getAttribute())).ifPresent(authEnabledAttribute -> {
            boolean isAuthEnabled = BooleanUtils.toBoolean((String)String.valueOf(authEnabledAttribute));
            if (isAuthEnabled) {
                EmailSettingsEnum.PASSWORD.getAttribute(integrationParams).ifPresent(password -> resultParams.put(EmailSettingsEnum.PASSWORD.getAttribute(), this.basicTextEncryptor.encrypt(password)));
            } else {
                resultParams.put(EmailSettingsEnum.PASSWORD.getAttribute(), null);
            }
            resultParams.put(EmailSettingsEnum.AUTH_ENABLED.getAttribute(), isAuthEnabled);
        });
        EmailSettingsEnum.STAR_TLS_ENABLED.getAttribute(integrationParams).ifPresent(attr -> resultParams.put(EmailSettingsEnum.STAR_TLS_ENABLED.getAttribute(), BooleanUtils.toBoolean((String)attr)));
        EmailSettingsEnum.SSL_ENABLED.getAttribute(integrationParams).ifPresent(attr -> resultParams.put(EmailSettingsEnum.SSL_ENABLED.getAttribute(), BooleanUtils.toBoolean((String)attr)));
        EmailSettingsEnum.HOST.getAttribute(integrationParams).ifPresent(attr -> resultParams.put(EmailSettingsEnum.HOST.getAttribute(), attr));
        EmailSettingsEnum.RP_HOST.getAttribute(integrationParams).filter(arg_0 -> ((UrlValidator)UrlValidator.getInstance()).isValid(arg_0)).ifPresent(attr -> resultParams.put(EmailSettingsEnum.RP_HOST.getAttribute(), attr));
        return resultParams;
    }

    @Override
    public Map<String, Object> retrieveUpdatedParams(String integrationType, Map<String, Object> integrationParams) {
        return this.retrieveCreateParams(integrationType, integrationParams);
    }

    @Override
    public Integration createIntegration(IntegrationRQ integrationRq, IntegrationType integrationType) {
        Integration integration = super.createIntegration(integrationRq, integrationType);
        this.sendConnectionTestEmail(integration, true);
        return integration;
    }

    @Override
    public Integration updateIntegration(Integration integration, IntegrationRQ integrationRq) {
        Integration updatedIntegration = super.updateIntegration(integration, integrationRq);
        this.sendConnectionTestEmail(updatedIntegration, false);
        return updatedIntegration;
    }

    @Override
    public boolean checkConnection(Integration integration) {
        return this.emailServiceFactory.getEmailService(integration).map(emailService -> {
            try {
                emailService.testConnection();
            }
            catch (MessagingException ex) {
                LOGGER.error("Connection to email server failed", (Throwable)ex);
                BusinessRule.fail().withError(ErrorType.EMAIL_CONFIGURATION_IS_INCORRECT, new Object[]{"Email configuration is incorrect. Please, check your configuration. " + ex.getMessage()});
                return false;
            }
            return true;
        }).orElse(false);
    }

    private void sendConnectionTestEmail(Integration integration, boolean isNewIntegration) {
        boolean isAuthEnabled = BooleanUtils.toBoolean((String)EmailSettingsEnum.AUTH_ENABLED.getAttribute(integration.getParams().getParams()).orElse("false"));
        this.emailServiceFactory.getEmailService(integration).ifPresent(emailService -> {
            if (isAuthEnabled) {
                try {
                    emailService.sendConnectionTestEmail(isNewIntegration);
                }
                catch (MessagingException ex) {
                    LOGGER.error("Cannot send email to user", (Throwable)ex);
                    BusinessRule.fail().withError(ErrorType.EMAIL_CONFIGURATION_IS_INCORRECT, new Object[]{"Email configuration is incorrect. Please, check your configuration. " + ex.getMessage()});
                }
            }
        });
    }
}

