/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.util;

import com.epam.reportportal.extension.CommonPluginCommand;
import com.epam.reportportal.extension.PluginCommand;
import com.epam.reportportal.extension.ReportPortalExtensionPoint;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.integration.util.IntegrationService;
import com.epam.ta.reportportal.core.plugin.PluginBox;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.entity.integration.IntegrationParams;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.model.integration.IntegrationRQ;
import com.epam.ta.reportportal.ws.converter.builders.IntegrationBuilder;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BasicIntegrationServiceImpl
implements IntegrationService {
    private static final String TEST_CONNECTION_COMMAND = "testConnection";
    private static final String RETRIEVE_CREATE_PARAMS = "retrieveCreate";
    private static final String RETRIEVE_UPDATED_PARAMS = "retrieveUpdated";
    protected IntegrationRepository integrationRepository;
    protected PluginBox pluginBox;

    @Autowired
    public BasicIntegrationServiceImpl(IntegrationRepository integrationRepository, PluginBox pluginBox) {
        this.integrationRepository = integrationRepository;
        this.pluginBox = pluginBox;
    }

    @Override
    public Integration createIntegration(IntegrationRQ integrationRq, IntegrationType integrationType) {
        return new IntegrationBuilder().withCreationDate(Instant.now()).withType(integrationType).withEnabled(integrationRq.getEnabled()).withName(integrationRq.getName()).withParams(new IntegrationParams(this.retrieveCreateParams(integrationType.getName(), integrationRq.getIntegrationParams()))).get();
    }

    @Override
    public Integration updateIntegration(Integration integration, IntegrationRQ integrationRQ) {
        Map<String, Object> validParams = this.retrieveUpdatedParams(integration.getType().getName(), integrationRQ.getIntegrationParams());
        IntegrationParams combinedParams = this.getCombinedParams(integration, validParams);
        integration.setParams(combinedParams);
        Optional.ofNullable(integrationRQ.getEnabled()).ifPresent(arg_0 -> ((Integration)integration).setEnabled(arg_0));
        Optional.ofNullable(integrationRQ.getName()).ifPresent(arg_0 -> ((Integration)integration).setName(arg_0));
        return integration;
    }

    @Override
    public Map<String, Object> retrieveCreateParams(String integrationType, Map<String, Object> integrationParams) {
        Optional<CommonPluginCommand<?>> pluginCommand = this.getCommonCommand(integrationType, RETRIEVE_CREATE_PARAMS);
        if (pluginCommand.isPresent()) {
            return (Map)pluginCommand.get().executeCommand(integrationParams);
        }
        return integrationParams;
    }

    @Override
    public Map<String, Object> retrieveUpdatedParams(String integrationType, Map<String, Object> integrationParams) {
        Optional<CommonPluginCommand<?>> pluginCommand = this.getCommonCommand(integrationType, RETRIEVE_UPDATED_PARAMS);
        if (pluginCommand.isPresent()) {
            return (Map)pluginCommand.get().executeCommand(integrationParams);
        }
        return integrationParams;
    }

    @Override
    public boolean checkConnection(Integration integration) {
        Optional<PluginCommand<?>> pluginCommand = this.getIntegrationCommand(integration.getType().getName(), TEST_CONNECTION_COMMAND);
        if (pluginCommand.isPresent()) {
            return (Boolean)pluginCommand.get().executeCommand(integration, integration.getParams().getParams());
        }
        return true;
    }

    private Optional<PluginCommand<?>> getIntegrationCommand(String integration, String commandName) {
        ReportPortalExtensionPoint pluginInstance = this.pluginBox.getInstance(integration, ReportPortalExtensionPoint.class).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Plugin for {} isn't installed", integration}));
        return Optional.ofNullable(pluginInstance.getIntegrationCommand(commandName));
    }

    private Optional<CommonPluginCommand<?>> getCommonCommand(String integration, String commandName) {
        ReportPortalExtensionPoint pluginInstance = this.pluginBox.getInstance(integration, ReportPortalExtensionPoint.class).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Plugin for {} isn't installed", integration}));
        return Optional.ofNullable(pluginInstance.getCommonCommand(commandName));
    }

    private IntegrationParams getCombinedParams(Integration integration, Map<String, Object> retrievedParams) {
        if (integration.getParams() != null && integration.getParams().getParams() != null) {
            integration.getParams().getParams().putAll(retrievedParams);
            return integration.getParams();
        }
        return new IntegrationParams(retrievedParams);
    }
}

