/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.plugin.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.activity.PluginUpdatedEvent;
import com.epam.ta.reportportal.core.integration.plugin.UpdatePluginHandler;
import com.epam.ta.reportportal.core.plugin.Pf4jPluginBox;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.entity.enums.PluginTypeEnum;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.model.activity.PluginActivityResource;
import com.epam.ta.reportportal.model.integration.UpdatePluginStateRQ;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class UpdatePluginHandlerImpl
implements UpdatePluginHandler {
    private final Pf4jPluginBox pluginBox;
    private final IntegrationTypeRepository integrationTypeRepository;
    private final ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public UpdatePluginHandlerImpl(Pf4jPluginBox pluginBox, IntegrationTypeRepository integrationTypeRepository, ApplicationEventPublisher applicationEventPublisher) {
        this.pluginBox = pluginBox;
        this.integrationTypeRepository = integrationTypeRepository;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public OperationCompletionRS updatePluginState(Long id, UpdatePluginStateRQ updatePluginStateRQ, ReportPortalUser user) {
        IntegrationType integrationType = (IntegrationType)this.integrationTypeRepository.findById((Object)id).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{Suppliers.formattedSupplier((String)"Integration type with id - '{}' not found.", (Object[])new Object[]{id}).get()}));
        boolean isEnabled = updatePluginStateRQ.getEnabled();
        integrationType.setEnabled(isEnabled);
        return this.handlePluginState(integrationType, isEnabled, user);
    }

    private OperationCompletionRS handlePluginState(IntegrationType integrationType, boolean isEnabled, ReportPortalUser user) {
        if (integrationType.getPluginType() != PluginTypeEnum.EXTENSION) {
            return new OperationCompletionRS((String)Suppliers.formattedSupplier((String)"Enabled state of the plugin with id = '{}' has been switched to - '{}'", (Object[])new Object[]{integrationType.getName(), isEnabled}).get());
        }
        if (isEnabled) {
            this.loadPlugin(integrationType);
        } else {
            this.unloadPlugin(integrationType);
        }
        this.publishEvent(integrationType, user, isEnabled);
        return new OperationCompletionRS((String)Suppliers.formattedSupplier((String)"Enabled state of the plugin with id = '{}' has been switched to - '{}'", (Object[])new Object[]{integrationType.getName(), isEnabled}).get());
    }

    private void loadPlugin(IntegrationType integrationType) {
        if (this.pluginBox.getPluginById(integrationType.getName()).isEmpty()) {
            boolean isLoaded = this.pluginBox.loadPlugin(integrationType.getName(), integrationType.getDetails());
            BusinessRule.expect((Object)isLoaded, BooleanUtils::isTrue).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{Suppliers.formattedSupplier((String)"Error during loading the plugin with id = '{}'", (Object[])new Object[]{integrationType.getName()}).get()});
        }
    }

    private void unloadPlugin(IntegrationType integrationType) {
        this.pluginBox.getPluginById(integrationType.getName()).ifPresent(plugin -> {
            if (!this.pluginBox.unloadPlugin(integrationType)) {
                throw new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{Suppliers.formattedSupplier((String)"Error during unloading the plugin with id = '{}'", (Object[])new Object[]{integrationType.getName()}).get()});
            }
        });
    }

    private void publishEvent(IntegrationType integrationType, ReportPortalUser user, boolean isEnabled) {
        PluginActivityResource before = new PluginActivityResource();
        before.setId(integrationType.getId());
        before.setName(integrationType.getName());
        before.setEnabled(!isEnabled);
        PluginActivityResource after = new PluginActivityResource();
        after.setId(integrationType.getId());
        after.setName(integrationType.getName());
        after.setEnabled(isEnabled);
        PluginUpdatedEvent pluginUpdatedEvent = new PluginUpdatedEvent(user.getUserId(), user.getUsername(), before, after);
        this.applicationEventPublisher.publishEvent((Object)pluginUpdatedEvent);
    }
}

