/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.plugin.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.activity.PluginDeletedEvent;
import com.epam.ta.reportportal.core.integration.plugin.DeletePluginHandler;
import com.epam.ta.reportportal.core.plugin.Pf4jPluginBox;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.entity.enums.ReservedIntegrationTypeEnum;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.model.activity.PluginActivityResource;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class DeletePluginHandlerImpl
implements DeletePluginHandler {
    private final IntegrationTypeRepository integrationTypeRepository;
    private final Pf4jPluginBox pluginBox;
    private final ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public DeletePluginHandlerImpl(IntegrationTypeRepository integrationTypeRepository, Pf4jPluginBox pluginBox, ApplicationEventPublisher applicationEventPublisher) {
        this.integrationTypeRepository = integrationTypeRepository;
        this.pluginBox = pluginBox;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public OperationCompletionRS deleteById(Long id, ReportPortalUser user) {
        IntegrationType integrationType = (IntegrationType)this.integrationTypeRepository.findById((Object)id).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_REMOVE_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Plugin with id = '{}' not found", (Object[])new Object[]{id}).get()}));
        BusinessRule.expect((Object)ReservedIntegrationTypeEnum.fromName((String)integrationType.getName()), Optional::isEmpty).verify(ErrorType.PLUGIN_REMOVE_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to remove reserved plugin - '{}'", (Object[])new Object[]{integrationType.getName()})});
        PluginActivityResource pluginActivityResource = new PluginActivityResource();
        pluginActivityResource.setName(integrationType.getName());
        pluginActivityResource.setId(integrationType.getId());
        if (!this.pluginBox.deletePlugin(integrationType.getName())) {
            throw new ReportPortalException(ErrorType.PLUGIN_REMOVE_ERROR, new Object[]{"Unable to remove from plugin manager."});
        }
        this.integrationTypeRepository.deleteById((Object)integrationType.getId());
        this.applicationEventPublisher.publishEvent((Object)new PluginDeletedEvent(pluginActivityResource, user.getUserId(), user.getUsername()));
        return new OperationCompletionRS((String)Suppliers.formattedSupplier((String)"Plugin = '{}' has been successfully removed", (Object[])new Object[]{integrationType.getName()}).get());
    }
}

