/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.plugin.binary;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.entity.attachment.BinaryData;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import jakarta.activation.FileTypeMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;

public class PluginFilesProvider {
    private final String baseDirectory;
    private final String folderQualifier;
    private final FileTypeMap fileTypeResolver;
    private final IntegrationTypeRepository integrationTypeRepository;

    public PluginFilesProvider(String baseDirectory, String folderQualifier, FileTypeMap fileTypeResolver, IntegrationTypeRepository integrationTypeRepository) {
        this.baseDirectory = baseDirectory;
        this.folderQualifier = folderQualifier;
        this.fileTypeResolver = fileTypeResolver;
        this.integrationTypeRepository = integrationTypeRepository;
    }

    public BinaryData load(String pluginName, String fileName) {
        IntegrationType integrationType = (IntegrationType)this.integrationTypeRepository.findByName(pluginName).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{pluginName}));
        File file = Paths.get(this.baseDirectory, integrationType.getName(), this.folderQualifier, fileName).toFile();
        if (!file.exists() || file.isDirectory()) {
            throw new ReportPortalException(ErrorType.UNABLE_TO_LOAD_BINARY_DATA, new Object[]{fileName});
        }
        return this.getBinaryData(file);
    }

    private BinaryData getBinaryData(File file) {
        try {
            FileInputStream fileStream = FileUtils.openInputStream((File)file);
            String contentType = this.fileTypeResolver.getContentType(file.getName());
            return new BinaryData(contentType, Long.valueOf(((InputStream)fileStream).available()), (InputStream)fileStream);
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.UNABLE_TO_LOAD_BINARY_DATA, new Object[]{e.getMessage()});
        }
    }
}

