/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.impl;

import com.epam.reportportal.extension.ReportPortalExtensionPoint;
import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.integration.ExecuteIntegrationHandler;
import com.epam.ta.reportportal.core.plugin.PluginBox;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ExecuteIntegrationHandlerImpl
implements ExecuteIntegrationHandler {
    private static final String ASYNC_MODE = "async";
    private static final String PROJECT_ID = "projectId";
    private static final String PROJECT_NAME = "projectName";
    private static final String PUBLIC_COMMAND_PREFIX = "public_";
    private final IntegrationRepository integrationRepository;
    private final PluginBox pluginBox;

    public ExecuteIntegrationHandlerImpl(IntegrationRepository integrationRepository, PluginBox pluginBox) {
        this.integrationRepository = integrationRepository;
        this.pluginBox = pluginBox;
    }

    @Override
    public Object executeCommand(ReportPortalUser.ProjectDetails projectDetails, String pluginName, String command, Map<String, Object> executionParams) {
        ReportPortalExtensionPoint pluginInstance = this.pluginBox.getInstance(pluginName, ReportPortalExtensionPoint.class).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Plugin for '{}' isn't installed", (Object[])new Object[]{pluginName}).get()}));
        executionParams.put(PROJECT_ID, projectDetails.getProjectId());
        executionParams.put(PROJECT_NAME, projectDetails.getProjectName());
        return Optional.ofNullable(pluginInstance.getCommonCommand(command)).map(it -> it.executeCommand(executionParams)).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Command '{}' is not found in plugin {}.", (Object[])new Object[]{command, pluginName}).get()}));
    }

    @Override
    public Object executePublicCommand(String pluginName, String command, Map<String, Object> executionParams) {
        BusinessRule.expect((Object)command, c -> c.startsWith(PUBLIC_COMMAND_PREFIX)).verify(ErrorType.ACCESS_DENIED, new Object[]{Suppliers.formattedSupplier((String)"Command '{}' is not public.", (Object[])new Object[]{command}).get()});
        ReportPortalExtensionPoint pluginInstance = this.pluginBox.getInstance(pluginName, ReportPortalExtensionPoint.class).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Plugin for '{}' isn't installed", (Object[])new Object[]{pluginName}).get()}));
        return Optional.ofNullable(pluginInstance.getCommonCommand(command)).map(it -> it.executeCommand(executionParams)).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Public command '{}' is not found in plugin {}.", (Object[])new Object[]{command, pluginName}).get()}));
    }

    @Override
    public Object executeCommand(ReportPortalUser.ProjectDetails projectDetails, Long integrationId, String command, Map<String, Object> executionParams) {
        Integration integration = this.integrationRepository.findByIdAndProjectId(integrationId, projectDetails.getProjectId()).orElseGet(() -> (Integration)this.integrationRepository.findGlobalById(integrationId).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{integrationId})));
        ReportPortalExtensionPoint pluginInstance = this.pluginBox.getInstance(integration.getType().getName(), ReportPortalExtensionPoint.class).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Plugin for '{}' isn't installed", (Object[])new Object[]{integration.getType().getName()}).get()}));
        executionParams.put(PROJECT_ID, projectDetails.getProjectId());
        return Optional.ofNullable(pluginInstance.getIntegrationCommand(command)).map(it -> {
            if (this.isAsyncMode(executionParams)) {
                this.supplyAsync(() -> it.executeCommand(integration, executionParams));
                return new OperationCompletionRS((String)Suppliers.formattedSupplier((String)"Command '{}' accepted for processing in plugin", (Object[])new Object[]{command, integration.getType().getName()}).get());
            }
            return it.executeCommand(integration, executionParams);
        }).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Command '{}' is not found in plugin {}.", (Object[])new Object[]{command, integration.getType().getName()}).get()}));
    }

    @Async
    @Deprecated
    public <U> void supplyAsync(Supplier<U> supplier) {
        supplier.get();
    }

    private boolean isAsyncMode(Map<String, Object> executionParams) {
        return Optional.ofNullable((Boolean)executionParams.get(ASYNC_MODE)).orElse(false);
    }
}

