/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.impl;

import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.activity.IntegrationDeletedEvent;
import com.epam.ta.reportportal.core.integration.DeleteIntegrationHandler;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.model.activity.IntegrationActivityResource;
import com.epam.ta.reportportal.ws.converter.converters.IntegrationConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class DeleteIntegrationHandlerImpl
implements DeleteIntegrationHandler {
    private final IntegrationRepository integrationRepository;
    private final ProjectRepository projectRepository;
    private final IntegrationTypeRepository integrationTypeRepository;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public DeleteIntegrationHandlerImpl(IntegrationRepository integrationRepository, ProjectRepository projectRepository, IntegrationTypeRepository integrationTypeRepository, ApplicationEventPublisher eventPublisher) {
        this.integrationRepository = integrationRepository;
        this.projectRepository = projectRepository;
        this.integrationTypeRepository = integrationTypeRepository;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public OperationCompletionRS deleteGlobalIntegration(Long integrationId, ReportPortalUser user) {
        Integration integration = (Integration)this.integrationRepository.findGlobalById(integrationId).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{integrationId}));
        this.publishActivities(List.of(integration), user);
        this.integrationRepository.deleteById((Object)integration.getId());
        return new OperationCompletionRS((String)Suppliers.formattedSupplier((String)"Global integration with id = {} has been successfully removed", (Object[])new Object[]{integration.getId()}).get());
    }

    @Override
    public OperationCompletionRS deleteGlobalIntegrationsByType(String type, ReportPortalUser user) {
        IntegrationType integrationType = (IntegrationType)this.integrationTypeRepository.findByName(type).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{type}));
        List integrations = this.integrationRepository.findAllGlobalInIntegrationTypeIds(Collections.singletonList(integrationType.getId()));
        this.publishActivities(integrations, user);
        this.integrationRepository.deleteAllGlobalByIntegrationTypeId(integrationType.getId());
        return new OperationCompletionRS("All global integrations with type ='" + integrationType.getName() + "' integrations have been successfully removed.");
    }

    @Override
    public OperationCompletionRS deleteProjectIntegration(Long integrationId, String projectName, ReportPortalUser user) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        Integration integration = (Integration)this.integrationRepository.findByIdAndProjectId(integrationId, project.getId()).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{integrationId}));
        integration.getProject().getIntegrations().removeIf(it -> it.getId().equals(integration.getId()));
        this.integrationRepository.deleteById((Object)integration.getId());
        this.eventPublisher.publishEvent((Object)new IntegrationDeletedEvent(IntegrationConverter.TO_ACTIVITY_RESOURCE.apply(integration), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("Integration with ID = '" + integrationId + "' has been successfully deleted.");
    }

    @Override
    public OperationCompletionRS deleteProjectIntegrationsByType(String type, String projectName, ReportPortalUser user) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        IntegrationType integrationType = (IntegrationType)this.integrationTypeRepository.findByName(type).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{type}));
        List integrations = this.integrationRepository.findAllByProjectIdAndInIntegrationTypeIds(project.getId(), Collections.singletonList(integrationType.getId()));
        this.publishActivities(integrations, user);
        this.integrationRepository.deleteAllByProjectIdAndIntegrationTypeId(project.getId(), integrationType.getId());
        return new OperationCompletionRS("All integrations with type ='" + type + "' for project with name ='" + project.getName() + "' have been successfully deleted");
    }

    private void publishActivities(List<Integration> integrations, ReportPortalUser user) {
        integrations.stream().map(IntegrationConverter.TO_ACTIVITY_RESOURCE).forEach(it -> this.eventPublisher.publishEvent((Object)new IntegrationDeletedEvent((IntegrationActivityResource)it, user.getUserId(), user.getUsername())));
    }
}

