/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.hierarchy.impl;

import com.epam.ta.reportportal.core.hierarchy.AbstractFinishHierarchyHandler;
import com.epam.ta.reportportal.core.item.impl.IssueTypeHandler;
import com.epam.ta.reportportal.core.item.impl.retry.RetryHandler;
import com.epam.ta.reportportal.core.item.impl.status.ChangeStatusHandler;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.ItemAttributeRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="finishTestItemHierarchyHandler")
public class FinishTestItemHierarchyHandler
extends AbstractFinishHierarchyHandler<TestItem> {
    public FinishTestItemHierarchyHandler(LaunchRepository launchRepository, TestItemRepository testItemRepository, ItemAttributeRepository itemAttributeRepository, IssueEntityRepository issueEntityRepository, RetryHandler retryHandler, IssueTypeHandler issueTypeHandler, ChangeStatusHandler changeStatusHandler) {
        super(launchRepository, testItemRepository, itemAttributeRepository, issueEntityRepository, retryHandler, issueTypeHandler, changeStatusHandler);
    }

    @Override
    protected boolean isIssueRequired(StatusEnum status, TestItem testItem) {
        return StatusEnum.FAILED.equals((Object)status) || Optional.ofNullable(testItem.getLaunchId()).map(launchId -> this.evaluateSkippedAttributeValue(status, (Long)launchId)).orElse(false) != false;
    }

    @Override
    protected Function<Pageable, List<Long>> getItemIdsFunction(boolean hasChildren, TestItem testItem, StatusEnum status) {
        return hasChildren ? pageable -> this.testItemRepository.findIdsByHasChildrenAndParentPathAndStatusOrderedByPathLevel(testItem.getPath(), StatusEnum.IN_PROGRESS, Integer.valueOf(pageable.getPageSize()), Long.valueOf(pageable.getOffset())) : pageable -> this.testItemRepository.findIdsByNotHasChildrenAndParentPathAndStatus(testItem.getPath(), status, Integer.valueOf(pageable.getPageSize()), Long.valueOf(pageable.getOffset()));
    }
}

