/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.hierarchy;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.hierarchy.FinishHierarchyHandler;
import com.epam.ta.reportportal.core.item.impl.IssueTypeHandler;
import com.epam.ta.reportportal.core.item.impl.retry.RetryHandler;
import com.epam.ta.reportportal.core.item.impl.status.ChangeStatusHandler;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.ItemAttributeRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.item.issue.IssueEntity;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.job.PageUtil;
import com.epam.ta.reportportal.jooq.enums.JStatusEnum;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.data.domain.Pageable;

public abstract class AbstractFinishHierarchyHandler<T>
implements FinishHierarchyHandler<T> {
    public static final int ITEM_PAGE_SIZE = 50;
    public static final String ATTRIBUTE_KEY_STATUS = "status";
    public static final String ATTRIBUTE_VALUE_INTERRUPTED = "interrupted";
    protected final LaunchRepository launchRepository;
    protected final TestItemRepository testItemRepository;
    protected final ItemAttributeRepository itemAttributeRepository;
    protected final IssueEntityRepository issueEntityRepository;
    private final RetryHandler retryHandler;
    private final IssueTypeHandler issueTypeHandler;
    private final ChangeStatusHandler changeStatusHandler;

    public AbstractFinishHierarchyHandler(LaunchRepository launchRepository, TestItemRepository testItemRepository, ItemAttributeRepository itemAttributeRepository, IssueEntityRepository issueEntityRepository, RetryHandler retryHandler, IssueTypeHandler issueTypeHandler, ChangeStatusHandler changeStatusHandler) {
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.itemAttributeRepository = itemAttributeRepository;
        this.issueEntityRepository = issueEntityRepository;
        this.retryHandler = retryHandler;
        this.issueTypeHandler = issueTypeHandler;
        this.changeStatusHandler = changeStatusHandler;
    }

    protected abstract boolean isIssueRequired(StatusEnum var1, T var2);

    protected abstract Function<Pageable, List<Long>> getItemIdsFunction(boolean var1, T var2, StatusEnum var3);

    protected boolean evaluateSkippedAttributeValue(StatusEnum status, Long launchId) {
        if (StatusEnum.SKIPPED.equals((Object)status)) {
            return this.itemAttributeRepository.findByLaunchIdAndKeyAndSystem(launchId, "skippedIssue", true).map(attribute -> BooleanUtils.toBoolean((String)attribute.getValue())).orElse(false);
        }
        return false;
    }

    protected Optional<IssueType> getIssueType(boolean isIssueRequired, Long projectId, String locator) {
        if (isIssueRequired) {
            return Optional.of(this.issueTypeHandler.defineIssueType(projectId, locator));
        }
        return Optional.empty();
    }

    @Override
    public int finishDescendants(T parentEntity, StatusEnum status, Instant endDate, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        BusinessRule.expect((Object)status, s -> s != StatusEnum.IN_PROGRESS).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Unable to update current status to - " + String.valueOf(StatusEnum.IN_PROGRESS)});
        int withoutChildren = this.updateDescendantsWithoutChildren(parentEntity, projectDetails.getProjectId(), status, endDate, user);
        int withChildren = this.updateDescendantsWithChildren(parentEntity, endDate);
        return withoutChildren + withChildren;
    }

    private int updateDescendantsWithoutChildren(T entity, Long projectId, StatusEnum status, Instant endTime, ReportPortalUser user) {
        AtomicInteger updatedCount = new AtomicInteger(0);
        this.getIssueType(this.isIssueRequired(status, entity), projectId, TestItemIssueGroup.TO_INVESTIGATE.getLocator()).ifPresentOrElse(issueType -> PageUtil.iterateOverContent(50, this.getItemIdsFunction(false, entity, StatusEnum.IN_PROGRESS), this.itemIdsWithoutChildrenHandler((IssueType)issueType, status, endTime, projectId, user, updatedCount)), () -> PageUtil.iterateOverContent(50, this.getItemIdsFunction(false, entity, StatusEnum.IN_PROGRESS), this.itemIdsWithoutChildrenHandler(status, endTime, projectId, user, updatedCount)));
        return updatedCount.get();
    }

    private Consumer<List<Long>> itemIdsWithoutChildrenHandler(IssueType issueType, StatusEnum status, Instant endTime, Long projectId, ReportPortalUser user, AtomicInteger updatedCount) {
        return itemIds -> {
            Map<Long, TestItem> itemMapping = this.getItemMapping((List<Long>)itemIds);
            itemIds.forEach(itemId -> Optional.ofNullable((TestItem)itemMapping.get(itemId)).ifPresent(testItem -> {
                this.finishItem((TestItem)testItem, status, endTime);
                this.attachIssue((TestItem)testItem, issueType);
                this.changeStatusHandler.changeParentStatus((TestItem)testItem, projectId, user);
            }));
            updatedCount.addAndGet(itemIds.size());
        };
    }

    private Consumer<List<Long>> itemIdsWithoutChildrenHandler(StatusEnum status, Instant endTime, Long projectId, ReportPortalUser user, AtomicInteger updatedCount) {
        return itemIds -> {
            Map<Long, TestItem> itemMapping = this.getItemMapping((List<Long>)itemIds);
            itemIds.forEach(itemId -> Optional.ofNullable((TestItem)itemMapping.get(itemId)).ifPresent(testItem -> {
                this.finishItem((TestItem)testItem, status, endTime);
                this.changeStatusHandler.changeParentStatus((TestItem)testItem, projectId, user);
            }));
            updatedCount.addAndGet(itemIds.size());
        };
    }

    private void attachIssue(TestItem testItem, IssueType issueType) {
        if (!TestItemTypeEnum.SUITE.sameLevel(testItem.getType()) && testItem.isHasStats()) {
            this.issueEntityRepository.findById((Object)testItem.getItemId()).ifPresentOrElse(issue -> {}, () -> {
                IssueEntity issueEntity = new IssueEntity();
                issueEntity.setIssueType(issueType);
                issueEntity.setTestItemResults(testItem.getItemResults());
                this.issueEntityRepository.save((Object)issueEntity);
                testItem.getItemResults().setIssue(issueEntity);
            });
        }
    }

    private int updateDescendantsWithChildren(T entity, Instant endTime) {
        AtomicInteger updatedCount = new AtomicInteger(0);
        PageUtil.iterateOverContent(50, this.getItemIdsFunction(true, entity, StatusEnum.IN_PROGRESS), this.itemIdsWithChildrenHandler(endTime, updatedCount));
        return updatedCount.get();
    }

    private Consumer<List<Long>> itemIdsWithChildrenHandler(Instant endTime, AtomicInteger updatedCount) {
        return itemIds -> {
            Map<Long, TestItem> itemMapping = this.getItemMapping((List<Long>)itemIds);
            itemIds.forEach(itemId -> Optional.ofNullable((TestItem)itemMapping.get(itemId)).ifPresent(testItem -> {
                boolean isFailed = this.testItemRepository.hasDescendantsNotInStatus(testItem.getItemId(), new String[]{StatusEnum.PASSED.name(), StatusEnum.INFO.name(), StatusEnum.WARN.name()});
                this.finishItem((TestItem)testItem, isFailed ? StatusEnum.FAILED : StatusEnum.PASSED, endTime);
            }));
            updatedCount.addAndGet(itemIds.size());
        };
    }

    private Map<Long, TestItem> getItemMapping(List<Long> itemIds) {
        return this.testItemRepository.findAllById(itemIds).stream().collect(Collectors.toMap(TestItem::getItemId, i -> i));
    }

    private void finishItem(TestItem testItem, StatusEnum status, Instant endTime) {
        testItem.getItemResults().setStatus(status);
        testItem.getItemResults().setEndTime(endTime);
        ItemAttribute interruptedAttribute = new ItemAttribute(ATTRIBUTE_KEY_STATUS, ATTRIBUTE_VALUE_INTERRUPTED, Boolean.valueOf(false));
        interruptedAttribute.setTestItem(testItem);
        testItem.getAttributes().add(interruptedAttribute);
        if (testItem.isHasRetries()) {
            this.retryHandler.finishRetries(testItem.getItemId(), JStatusEnum.valueOf((String)status.name()), endTime);
        }
    }
}

