/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.ProjectFilter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.filter.GetUserFilterHandler;
import com.epam.ta.reportportal.dao.UserFilterRepository;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.model.OwnedEntityResource;
import com.epam.ta.reportportal.model.filter.UserFilterResource;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.UserFilterConverter;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class GetUserFilterHandlerImpl
implements GetUserFilterHandler {
    private UserFilterRepository filterRepository;
    private final ProjectExtractor projectExtractor;

    @Autowired
    public GetUserFilterHandlerImpl(ProjectExtractor projectExtractor) {
        this.projectExtractor = projectExtractor;
    }

    @Autowired
    public void setFilterRepository(UserFilterRepository filterRepository) {
        this.filterRepository = filterRepository;
    }

    @Override
    public UserFilterResource getUserFilter(Long id, ReportPortalUser.ProjectDetails projectDetails) {
        UserFilter userFilter = (UserFilter)this.filterRepository.findByIdAndProjectId(id, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_FILTER_NOT_FOUND_IN_PROJECT, new Object[]{id, projectDetails.getProjectName()}));
        return UserFilterConverter.TO_FILTER_RESOURCE.apply(userFilter);
    }

    @Override
    public com.epam.ta.reportportal.model.Page<UserFilterResource> getUserFilters(String projectName, Pageable pageable, Filter filter, ReportPortalUser user) {
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetails(user, projectName);
        Page userFilters = this.filterRepository.findByFilter((Queryable)ProjectFilter.of((Queryable)filter, (Long)projectDetails.getProjectId()), pageable);
        return PagedResourcesAssembler.pageConverter(UserFilterConverter.TO_FILTER_RESOURCE).apply((Page<UserFilter>)userFilters);
    }

    @Override
    public com.epam.ta.reportportal.model.Page<OwnedEntityResource> getFiltersNames(ReportPortalUser.ProjectDetails projectDetails, Pageable pageable, Filter filter, ReportPortalUser user) {
        Page userFilters = this.filterRepository.findByFilter((Queryable)ProjectFilter.of((Queryable)filter, (Long)projectDetails.getProjectId()), pageable);
        return PagedResourcesAssembler.pageConverter(UserFilterConverter.TO_OWNED_ENTITY_RESOURCE).apply((Page<UserFilter>)userFilters);
    }

    @Override
    public List<UserFilter> getFiltersById(Long[] ids, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        return this.filterRepository.findAllByIdInAndProjectId((Collection)Lists.newArrayList((Object[])ids), projectDetails.getProjectId());
    }
}

