/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.FilterDeletedEvent;
import com.epam.ta.reportportal.core.filter.DeleteUserFilterHandler;
import com.epam.ta.reportportal.dao.UserFilterRepository;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.ws.converter.converters.UserFilterConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteUserFilterHandlerImpl
implements DeleteUserFilterHandler {
    private final UserFilterRepository userFilterRepository;
    private final MessageBus messageBus;

    @Autowired
    public DeleteUserFilterHandlerImpl(UserFilterRepository userFilterRepository, MessageBus messageBus) {
        this.userFilterRepository = userFilterRepository;
        this.messageBus = messageBus;
    }

    @Override
    public OperationCompletionRS deleteFilter(Long id, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        UserFilter userFilter = (UserFilter)this.userFilterRepository.findByIdAndProjectId(id, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_FILTER_NOT_FOUND_IN_PROJECT, new Object[]{id, projectDetails.getProjectName()}));
        BusinessRule.expect((Object)userFilter.getProject().getId(), Predicate.isEqual(projectDetails.getProjectId())).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{id, projectDetails.getProjectId(), user.getUserId()});
        this.userFilterRepository.delete((Object)userFilter);
        this.messageBus.publishActivity(new FilterDeletedEvent(UserFilterConverter.TO_ACTIVITY_RESOURCE.apply(userFilter), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("User filter with ID = '" + id + "' successfully deleted.");
    }
}

