/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.file.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.binary.AttachmentBinaryDataService;
import com.epam.ta.reportportal.binary.UserBinaryDataService;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.file.GetFileHandler;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.attachment.BinaryData;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.util.ProjectExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
public class GetFileHandlerImpl
implements GetFileHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetFileHandlerImpl.class);
    private static final String DEFAULT_USER_PHOTO = "image/defaultAvatar.png";
    private final UserRepository userRepository;
    private final UserBinaryDataService userDataStoreService;
    private final AttachmentBinaryDataService attachmentBinaryDataService;
    private final ProjectExtractor projectExtractor;

    @Override
    public BinaryData getUserPhoto(ReportPortalUser loggedInUser, boolean loadThumbnail) {
        User user = (User)this.userRepository.findByLogin(loggedInUser.getUsername()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{loggedInUser.getUsername()}));
        return this.userDataStoreService.loadUserPhoto(user, loadThumbnail);
    }

    @Override
    public BinaryData getUserPhoto(String username, ReportPortalUser loggedInUser, String projectName, boolean loadThumbnail) {
        Optional userOptional = this.userRepository.findByLogin(username);
        if (userOptional.isEmpty()) {
            log.warn("User '{}' not found", (Object)username);
            return this.getDefaultPhoto();
        }
        User user = (User)userOptional.get();
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetailsAdmin(loggedInUser, projectName);
        if (loggedInUser.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)ProjectUtils.isAssignedToProject((User)user, (Long)projectDetails.getProjectId()), Predicate.isEqual(true)).verify(ErrorType.ACCESS_DENIED, new Object[]{Suppliers.formattedSupplier((String)"You are not assigned to project '{}'", (Object[])new Object[]{projectDetails.getProjectName()})});
        }
        return this.userDataStoreService.loadUserPhoto(user, loadThumbnail);
    }

    @Override
    public BinaryData loadFileById(Long fileId, ReportPortalUser.ProjectDetails projectDetails) {
        return this.attachmentBinaryDataService.load(fileId, projectDetails);
    }

    private BinaryData getDefaultPhoto() {
        try {
            InputStream data = new ClassPathResource(DEFAULT_USER_PHOTO).getInputStream();
            String contentType = "image/jpeg";
            return new BinaryData(contentType, Long.valueOf(data.available()), data);
        }
        catch (IOException e) {
            log.error("Unable to load default photo", (Throwable)e);
            throw new ReportPortalException(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[]{"Unable to load default photo"});
        }
    }

    @Generated
    public GetFileHandlerImpl(UserRepository userRepository, UserBinaryDataService userDataStoreService, AttachmentBinaryDataService attachmentBinaryDataService, ProjectExtractor projectExtractor) {
        this.userRepository = userRepository;
        this.userDataStoreService = userDataStoreService;
        this.attachmentBinaryDataService = attachmentBinaryDataService;
        this.projectExtractor = projectExtractor;
    }
}

